% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/coxstuff.R
\docType{class}
\name{CoxMaster}
\alias{CoxMaster}
\title{Create a master object to control worker objects generated by \code{\link{CoxSlave}}}
\format{An \code{\link{R6Class}} generator object}
\usage{
CoxMaster
}
\description{
\code{CoxMaster} objects instantiate and run a distributed Cox model
computation fit
}
\section{Methods}{


\describe{
  \item{\code{CoxMaster$new(defnId, formula, debug=FALSE)}}{Create a new
        CoxMaster object using the defnId and formula. The debug flag is useful for
        debugging}
  \item{\code{logLik(beta, ...)}}{Compute the partial log likelihood for all the data
        by aggregating the values at each site. The return value is numeric scalar with
        two attributes: \code{gradient} contains the score vector, and \code{hessian}
        contains the estimated hessian matrix}
  \item{\code{addSite(name, url)}}{Add a worker
        site for participating in the distributed computation}
  \item{\code{var(beta, ...)}}{Compute the variance of the parameter vector beta}
  \item{\code{kosher()}}{Check if inputs and state of object are sane. For future use}
  \item{\code{getP()}}{Returns the dimension of the parameter vector}
  \item{\code{run()}}{Run the fitting iterations and save the result}
  \item{\code{summary()}}{Return a summary data frame columns for \code{coef}, \code{exp(coef)},
        standard error, z-score, and p-value for each parameter in the model following
        the same format as the \code{survival} package}
}
}
\seealso{
\code{CoxSlave} which generates objects matched to such a master object
}
\keyword{datasets}

