% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrapper_TruncatedDistribution.R
\name{TruncatedDistribution}
\alias{TruncatedDistribution}
\title{Distribution Truncation Wrapper}
\value{
Returns an R6 object of class TruncatedDistribution.
}
\description{
A wrapper for truncating any probability distribution at given limits.
}
\details{
Truncates a distribution at lower and upper limits, using the formulae
\deqn{f_T(x) = f_X(x) / (F_X(upper) - F_X(lower))}
\deqn{F_T(x) = (F_X(x) - F_X(lower)) / (F_X(upper) - F_X(lower))}
where \eqn{f_T}/\eqn{F_T} is the pdf/cdf of the truncated distribution T = Truncate(X, lower, upper) and
\eqn{f_X}, \eqn{F_X} is the pdf/cdf of the original distribution.

If lower or upper are NULL they are taken to be \code{self$inf()} and \code{self$sup()} respectively.
The support of the new distribution is the interval of points between lower and upper.

The pdf and cdf of the distribution are required for this wrapper, if unavailable decorate with
\code{FunctionImputation} first.
}
\section{Constructor}{
 TruncatedDistribution$new(distribution, lower = NULL, upper = NULL)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{distribution} \tab distribution \tab Distribution to truncate. \cr
\code{lower} \tab numeric \tab Lower limit for truncation. \cr
\code{upper} \tab numeric \tab Upper limit for truncation.
}
}

\section{Public Variables}{

 \tabular{ll}{
  \strong{Variable} \tab \strong{Return} \cr
  \code{name} \tab Name of distribution. \cr
  \code{short_name} \tab Id of distribution. \cr
  \code{description} \tab Brief description of distribution. \cr
  \code{package} \tab The package d/p/q/r are implemented in.
 }
}

\section{Public Methods}{

 \tabular{ll}{
  \strong{Accessor Methods} \tab \strong{Link} \cr
  \code{wrappedModels(model = NULL)} \tab \code{\link{wrappedModels}} \cr
  \code{decorators()} \tab \code{\link{decorators}} \cr
  \code{traits()} \tab \code{\link{traits}} \cr
  \code{valueSupport()} \tab \code{\link{valueSupport}} \cr
  \code{variateForm()} \tab \code{\link{variateForm}} \cr
  \code{type()} \tab \code{\link{type}} \cr
  \code{properties()} \tab \code{\link{properties}} \cr
  \code{support()} \tab \code{\link{support}} \cr
  \code{symmetry()} \tab \code{\link{symmetry}} \cr
  \code{sup()}  \tab \code{\link{sup}} \cr
  \code{inf()} \tab \code{\link{inf}} \cr
  \code{dmax()}  \tab \code{\link{dmax}} \cr
  \code{dmin()} \tab \code{\link{dmin}} \cr
  \code{skewnessType()} \tab \code{\link{skewnessType}} \cr
  \code{kurtosisType()} \tab \code{\link{kurtosisType}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{d/p/q/r Methods} \tab \strong{Link} \cr
  \code{pdf(x1, ..., log = FALSE, simplify = TRUE)} \tab \code{\link{pdf}} \cr
  \code{cdf(x1, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{cdf}}\cr
  \code{quantile(p, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{quantile.Distribution}} \cr
  \code{rand(n, simplify = TRUE)} \tab \code{\link{rand}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Statistical Methods} \tab \strong{Link} \cr
  \code{prec()} \tab \code{\link{prec}} \cr
  \code{stdev()} \tab \code{\link{stdev}}\cr
  \code{median()} \tab \code{\link{median.Distribution}} \cr
  \code{iqr()} \tab \code{\link{iqr}} \cr
  \code{cor()} \tab \code{\link{cor}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Parameter Methods} \tab \strong{Link} \cr
  \code{parameters(id)} \tab \code{\link{parameters}} \cr
  \code{getParameterValue(id, error = "warn")}  \tab \code{\link{getParameterValue}} \cr
  \code{setParameterValue(..., lst = NULL, error = "warn")} \tab \code{\link{setParameterValue}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Validation Methods} \tab \strong{Link} \cr
  \code{liesInSupport(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInSupport}} \cr
  \code{liesInType(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInType}} \cr
  \tab \cr \tab \cr \tab \cr
  \strong{Representation Methods} \tab \strong{Link} \cr
  \code{strprint()} \tab \code{\link{strprint}} \cr
  \code{print()} \tab \code{\link[base]{print}} \cr
  \code{summary(full = T)} \tab \code{\link{summary.Distribution}} \cr
  \code{plot()} \tab Coming Soon. \cr
  \code{qqplot()} \tab Coming Soon. \cr
  }
}

\examples{
truncBin <- TruncatedDistribution$new(
            Binomial$new(prob = 0.5, size = 10),
            lower = 2, upper = 4)
truncBin$getParameterValue("prob")

}
\seealso{
\code{\link{listWrappers}}, \code{\link{FunctionImputation}}, \code{\link{truncate}}
}
