% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testDistributionList}
\alias{testDistributionList}
\alias{checkDistributionList}
\alias{assertDistributionList}
\title{assert/check/test/DistributionList}
\usage{
testDistributionList(object,
  errormsg = "One or more items in the list are not Distributions")

checkDistributionList(object,
  errormsg = "One or more items in the list are not Distributions")

assertDistributionList(object,
  errormsg = "One or more items in the list are not Distributions")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
  return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
  an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is a list of R6 Distributions.
}
\examples{
testDistributionList(list(Binomial$new(),5)) # FALSE
testDistributionList(list(Binomial$new(),Exponential$new())) # TRUE

}
