% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{api_url}
\alias{api_url}
\alias{api_set_url}
\alias{api_available_models}
\alias{api_get_current_beta}
\alias{api_model_trace}
\alias{api_model_specification}
\alias{api_submit_gradient}
\alias{api_model_converged}
\alias{api_setup_model}
\alias{api_clear_model}
\alias{api_estimate_model}
\title{API Functions and wrappers}
\usage{
api_url(url = NULL)

api_set_url(url)

api_available_models(url = api_url(), config = list(), ...)

api_get_current_beta(model_name, url = api_url(), config = list(), ...)

api_model_trace(model_name, url = api_url(), config = list(), ...)

api_model_specification(model_name, url = api_url(), config = list(), ...)

api_submit_gradient(
  model_name,
  url = api_url(),
  data,
  site_name,
  shuffle_rows = TRUE,
  verbose = TRUE,
  dry_run = FALSE,
  config = list(),
  ...
)

api_model_converged(model_name, url = api_url(), config = list(), ...)

api_setup_model(
  model_name,
  url = api_url(),
  formula = "y ~ x1 + x2",
  family = "binomial",
  link = "logit",
  all_site_names,
  config = list(),
  tolerance = 1e-09,
  ...
)

api_clear_model(model_name, url = api_url(), config = list(), ...)

api_estimate_model(
  model_name,
  url = api_url(),
  data,
  site_name,
  wait_time = 1,
  config = list(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{url}{URL to the Plumber Server}

\item{config}{additional configuration settings such as http
authentication and additional headers.}

\item{...}{additional arguments to send to
\code{\link{api_submit_gradient}}}

\item{model_name}{name of your model}

\item{data}{dataset to get gradient value from.  The code runs
\code{\link{gradient_value}} to calculate the gradient, no individual
data is submitted.}

\item{site_name}{name of the site, needs to be one of the
\code{all_site_names}}

\item{shuffle_rows}{should the rows of the dataset be permuted, so
as to decrease privacy concerns}

\item{verbose}{print out diagnostic messages}

\item{dry_run}{if \code{TRUE}, nothing with respect to the data
is submitted to the server, but returned to see what would be submitted.}

\item{formula}{model formula to fit, with tilde syntax}

\item{family}{generalized linear model family, see \code{\link{family}}}

\item{link}{link function to use with family}

\item{all_site_names}{all the site names to fit this model}

\item{tolerance}{tolerance for convergence}

\item{wait_time}{Time, in seconds, to wait until to try to
get new estimate}
}
\value{
The \code{api_available_models} function returns the available
models running or already run.

The \code{api_get_current_beta} function returns the current beta
estimates.

The \code{api_model_trace} function returns a list of the values
throughout iterations of the model fitting.

The \code{api_model_specification} function returns a list of the
parameters of the model specification, if the model is present.

The \code{api_submit_gradient} function returns a list from the result of
the API call.

The \code{api_model_converged} function returns an indicator if
the model converges or not.

The \code{api_setup_model} function submits a model to set up on the
server.

The \code{api_clear_model} function clears out a model and returns the
output from the API.
}
\description{
API Functions and wrappers
}
\examples{
api_url()
api_set_url(api_url())
api_available_models()

}
