% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{do_provision_glm_api}
\alias{do_provision_glm_api}
\alias{do_remove_glm_api}
\alias{do_deploy_glm_api}
\alias{do_deploy_glm_api_only}
\alias{do_list_plumber}
\title{Deploy GLM API on Digital Ocean (DO)}
\usage{
do_provision_glm_api(
  ...,
  application_name = "glm",
  port = 8000,
  example = FALSE,
  r_packages = NULL,
  github_r_packages = NULL
)

do_remove_glm_api(droplet, application_name = "glm", ...)

do_deploy_glm_api(
  ...,
  application_name = "glm",
  port = 8000,
  docs = TRUE,
  forward = TRUE,
  example = FALSE
)

do_deploy_glm_api_only(
  droplet,
  application_name = "glm",
  port = 8000,
  docs = TRUE,
  forward = TRUE,
  ...
)

do_list_plumber(droplet, ...)
}
\arguments{
\item{...}{arguments to pass to \code{do_provision} from
\code{plumberDeploy} package}

\item{application_name}{Name of application, passed to \code{path}
argument of \code{do_deploy_api} function from \code{plumberDeploy} package}

\item{port}{port to deploy on Digital Ocean}

\item{example}{If TRUE, will deploy an example API
named hello to the server on port 8000.}

\item{r_packages}{Additional R packages to install, using
\code{install.packages}}

\item{github_r_packages}{Additional R packages to install from GitHub, using
\code{remotes::install_github}}

\item{droplet}{droplet to deploy on}

\item{docs}{enable the Swagger interface,
passed to \code{do_deploy_api} function from
\code{plumberDeploy} package}

\item{forward}{setup requests targeting the root URL on the
server to point to this application,
passed to \code{do_deploy_api} function from
\code{plumberDeploy} package}
}
\value{
A droplet instance
}
\description{
Deploy GLM API on Digital Ocean (DO)
}
\examples{
\dontrun{
  d = analogsea::droplets()
  if (length(d) == 0) {
    droplet = NULL
  } else {
    droplet = d[[1]]
  }
  droplet = do_provision_glm_api(droplet = droplet, region = "sfo3")
  droplet = do_deploy_glm_api_only(droplet)
  ip = droplet$network$v4[[1]]$ip_address
  applet_url = paste0("http://", ip, "/", droplet$application_name,
                      "/__docs__/")
  if (interactive()) {
    browseURL(applet_url)
  }
}
}
