% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunedivfor.R
\encoding{UTF-8}
\name{tunedivfor}
\alias{tunedivfor}
\title{Optimization of the values of the tuning parameters \code{nsplits} and \code{proptry}}
\usage{
tunedivfor(
  formula = NULL,
  data = NULL,
  nsplitsgrid = c(2, 5, 10, 30, 50, 100, 200),
  proptrygrid = c(0.05, 1),
  num.trees.pre = 500
)
}
\arguments{
\item{formula}{Object of class \code{formula} or \code{character} describing the model to fit. Interaction terms supported only for numerical variables.}

\item{data}{Training data of class \code{data.frame}, \code{matrix}, \code{dgCMatrix} (Matrix) or \code{gwaa.data} (GenABEL).}

\item{nsplitsgrid}{Grid of values to consider for \code{nsplits}. Default grid: 2, 5, 10, 30, 50, 100, 200.}

\item{proptrygrid}{Grid of values to consider for \code{proptry}. Default grid: 0.05, 1.}

\item{num.trees.pre}{Number of trees used for each forest constructed during tuning parameter optimization. Default is 500.}
}
\value{
List with elements
  \item{\code{nsplitsopt}}{Optimized value of \code{nsplits}.}
  \item{\code{proptryopt}}{Optimized value of \code{proptry}.}
  \item{\code{tunegrid}}{Two-dimensional \code{data.frame}, where each row contains one pair of values considered for \code{nsplits} (first entry) and \code{proptry} (second entry).}
  \item{\code{ooberrs}}{The out-of-bag prediction errors obtained for each pair of values considered for \code{nsplits} and \code{proptry}, where the ordering of pairs of values is the same as in \code{tunegrid} (see above).}
}
\description{
First, both for \code{nsplits} and \code{proptry} a grid of possible values may be provided,
where default grids are used if no grids are provided. Second, for each pairwise combination of
values from these two grids a forest is constructed. Third, 
that pair of \code{nsplits} and \code{proptry} values is used as the optimized set of parameter
values that is associated with the smallest out-of-bag prediction error. If several pairs of
parameter values are associated with the same smallest out-of-bag prediction error, the
pair with the smallest (parameter) values is used.
}
\examples{

## Load package:

library("diversityForest")


## Set seed to obtain reproducible results:

set.seed(1234)


## Tuning parameter optimization for the iris data set:

tuneres <- tunedivfor(formula = Species ~ ., data = iris, num.trees.pre = 20)
# NOTE: num.trees.pre = 20 is specified too small for practical 
# purposes - the out-of-bag error estimates of the forests 
# constructed during optimization will be much too variable!!
# In practice, num.trees.pre = 500 (default value) or a 
# larger number should be used.

tuneres

tuneres$nsplitsopt
tuneres$proptryopt
tuneres$tunegrid
tuneres$ooberrs

}
\references{
\itemize{
  \item Hornung, R. (2022). "Diversity forests: Using split sampling to enable innovative complex split procedures in random forests". SN Computer Science 3(2):1, <\doi{10.1007/s42979-021-00920-1}>.
  \item Wright, M. N. & Ziegler, A. (2017). "ranger: A fast Implementation of Random Forests for High Dimensional Data in C++ and R". J Stat Softw 77:1-17, <\doi{10.18637/jss.v077.i01}>.
  }
}
\seealso{
\code{\link{divfor}}
}
\author{
Roman Hornung
}
