% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panes.R
\name{partitions}
\alias{partitions}
\title{Distribute events specified intervals.}
\usage{
partitions(
  date,
  window = number_line(0, Inf),
  windows_total = 1,
  separate = FALSE,
  sn = NULL,
  strata = NULL,
  data_links = "ANY",
  custom_sort = NULL,
  group_stats = FALSE,
  data_source = NULL,
  by = NULL,
  length.out = NULL,
  fill = TRUE,
  display = "none"
)
}
\arguments{
\item{date}{\code{[date|datetime|integer|\link{number_line}]}. Event date or period.}

\item{window}{\code{[integer|\link{number_line}]}. Numeric or time intervals.}

\item{windows_total}{\code{[integer|\link{number_line}]}. Minimum number of matched \code{windows} required for a pane. See \code{details}}

\item{separate}{\code{[logical]}. If \code{TRUE}, events matched to different \code{windows} are not linked.}

\item{sn}{\code{[integer]}. Unique record identifier. Useful for creating familiar \code{\link[=pane-class]{pane}} identifiers.}

\item{strata}{\code{[atomic]}. Subsets of the dataset. Panes are created separately for each \code{strata}.}

\item{data_links}{\code{[list|character]}. A set of \code{data_sources} required in each \code{\link[=pane-class]{pane}}. A \code{\link[=pane-class]{pane}} without records from these \code{data_sources} will be unlinked. See \code{Details}.}

\item{custom_sort}{\code{[atomic]}. Preferred order for selecting \code{"index"} events.}

\item{group_stats}{\code{[logical]}. If \code{TRUE} (default), the returned \code{pane} object will include group specific information like panes start and end dates.}

\item{data_source}{\code{[character]}. Unique data source identifier. Adds the list of datasets in each pane to the \code{\link[=pane-class]{pane}}. Useful when the dataset has data from multiple sources.}

\item{by}{\code{[integer]}. Width of splits.}

\item{length.out}{\code{[integer]}. Number of splits.}

\item{fill}{\code{[logical]}. Retain (\code{TRUE}) or drop (\code{FALSE}) the remainder of an uneven split.}

\item{display}{\code{[character]}. The progress messages printed on screen. Options are; \code{"none"} (default) or \code{"stats"}.}
}
\value{


\code{\link[=pane-class]{pane}}
}
\description{
Distribute events into groups defined by time or numerical intervals.
Each set of linked records are assigned a unique identifier with relevant group-level data.
}
\details{
Each assigned group is referred to as a \code{\link[=pane-class]{pane}} A \code{\link[=pane-class]{pane}} consists of events within a specific time or numerical intervals (\code{window}).

Each \code{window} must cover a separate interval. Overlapping \code{windows} are merged before events are distributed into panes.
Events that occur over two \code{windows} are assigned to the last one listed.

Alternatively, you can create \code{windows} by splitting a period into equal parts (\code{length.out}), or into a sequence of intervals with fixed widths (\code{by}).

By default, the earliest event is taken as the \code{"Index"} event of the \code{\link[=pane-class]{pane}}.
An alternative can be chosen with \code{custom_sort}.

\bold{\code{partitions()}} will categorise records into 3 types;
\itemize{
\item \code{"Index"} - Index event/record of the pane.
\item \code{"Duplicate_I"} - Duplicate of the \code{"Index"} record.
\item \code{"Skipped"} - Records that are not assigned to a pane.
}

Every element in \code{data_links} must be named \code{"l"} (links) or \code{"g"} (groups).
Unnamed elements of \code{data_links} will be assumed to be \code{"l"}.
\itemize{
\item If named \code{"l"}, only groups with records from every listed \code{data_source} will be retained.
\item If named \code{"g"}, only groups with records from any listed \code{data_source} will be retained.
}

\emph{\code{NA} values in \code{strata} excludes records from the partitioning tracking process}.

See \code{vignette("episodes")} for more information.
}
\examples{
events <- c(30, 2, 11, 10, 100)
windows <- number_line(c(1, 9, 25), c(3, 12, 35))

events
partitions(date = events, length.out = 3, separate = TRUE)
partitions(date = events, by = 10, separate = TRUE)
partitions(date = events, window = windows, separate = TRUE)
partitions(date = events, window = windows, separate = FALSE)
partitions(date = events, window = windows, separate = FALSE, windows_total = 4)

}
\seealso{
\code{\link[=pane-class]{pane}}; \code{\link{number_line_sequence}}; \code{\link{episodes}}; \code{\link{links}}; \code{\link{overlaps}}; \code{\link{number_line}}; \code{\link{schema}}
}
