% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transformation_report}
\alias{transformation_report}
\title{Reporting the information of transformation}
\usage{
transformation_report(
  .data,
  target = NULL,
  output_format = c("pdf", "html"),
  output_file = NULL,
  output_dir = tempdir(),
  font_family = NULL,
  browse = TRUE
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{target}{target variable. If the target variable is not specified,
the method of using the target variable information is not performed when
the missing value is imputed. and Optimal binning is not performed if the
target variable is not a binary class.}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by knitr::knit().
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{font_family}{charcter. font family name for figure in pdf.}

\item{browse}{logical. choose whether to output the report results to the browser.}
}
\description{
The transformation_report() report the information of transformate
numerical variables for object inheriting from data.frame.
}
\details{
Generate transformation reports automatically.
You can choose to output to pdf and html files.
This is useful for Binning a data frame with a large number of variables
than data with a small number of variables.
For pdf output, Korean Gothic font must be installed in Korean operating system.
}
\section{Reported information}{

The transformation process will report the following information:

\itemize{
  \item Imputation
  \itemize{
    \item Missing Values
    \itemize{
      \item * Variable names including missing value
    }
    \item Outliers
    \itemize{
      \item * Variable names including outliers
    }
  }
  \item Resolving Skewness
  \itemize{
    \item Skewed variables information
    \itemize{
      \item * Variable names with an absolute value of skewness greater than or equal to 0.5
    }
  }
  \item Binning
  \itemize{
    \item Numerical Variables for Binning
    \item Binning
    \itemize{
      \item Numeric variable names
    }
    \item Optimal Binning
    \itemize{
      \item Numeric variable names
    }
  }
}

See vignette("transformation") for an introduction to these concepts.
}

\examples{
\donttest{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# reporting the Binning information -------------------------
# create pdf file. file name is Transformation_Report.pdf & No target variable
transformation_report(carseats)
# create pdf file. file name is Transformation_Report.pdf
transformation_report(carseats, US)
# create pdf file. file name is Transformation.pdf
transformation_report(carseats, "US", output_file = "Transformation.pdf")
# create html file. file name is Transformation_Report.html
transformation_report(carseats, "US", output_format = "html")
# create html file. file name is Transformation.html
transformation_report(carseats, US, output_format = "html", output_file = "Transformation.html")
}

}
