% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{materialize}
\alias{materialize}
\alias{compute.dm}
\alias{collect.dm}
\title{Materialize}
\usage{
\method{compute}{dm}(x, ...)

\method{collect}{dm}(x, ...)
}
\arguments{
\item{x}{A \code{dm}.}

\item{...}{Passed on to \code{\link[=compute]{compute()}}.}
}
\value{
A \code{dm} object of the same structure as the input.
}
\description{
\code{compute()} materializes all tables in a \code{dm} to new (temporary or permanent)
tables on the database.

\code{collect()} downloads the tables in a \code{dm} object as local \link{tibble}s.
}
\details{
Called on a \code{dm} object, these methods create a copy of all tables in the \code{dm}.
Depending on the size of your data this may take a long time.
}
\examples{
\dontshow{if (dm:::dm_has_financial()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
financial <- dm_financial_sqlite()

financial \%>\%
  pull_tbl(districts) \%>\%
  dbplyr::remote_name()

# compute() copies the data to new tables:
financial \%>\%
  compute() \%>\%
  pull_tbl(districts) \%>\%
  dbplyr::remote_name()

# collect() returns a local dm:
financial \%>\%
  collect() \%>\%
  pull_tbl(districts) \%>\%
  class()
\dontshow{\}) # examplesIf}
}
