% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx2pdf.R
\name{pptx2pdf}
\alias{pptx2pdf}
\title{Convert pptx to pdf}
\usage{
pptx2pdf(input, output = gsub("\\\\.pptx$", ".pdf", input))
}
\arguments{
\item{input, output}{file input and optional file output (default
to input with pdf extension).}
}
\value{
the name of the produced pdf (the same value as \code{output})
}
\description{
Convert pptx to pdf directly using "Microsoft PowerPoint".
This function will not work if "Microsoft PowerPoint" is not available
on your machine.

The calls to "Microsoft PowerPoint" are made differently depending on
the operating system. On "Windows", a "PowerShell" script using COM
technology is used to control "Microsoft PowerPoint". On macOS, an
"AppleScript" script is used to control "Microsoft PowerPoint".
}
\section{Macos manual authorizations}{

On macOS the call is happening into a working
directory managed with function \code{\link[=working_directory]{working_directory()}}.

Manual interventions are necessary to authorize
'PowerPoint' applications to write in a single directory: the working directory.
These permissions must be set manually, this is required by the macOS security
policy. We think that this is not a problem because it is unlikely that you will
use a Mac machine as a server.

You must also click "allow" two times to:
\enumerate{
\item allow R to run 'AppleScript' scripts that will control PowerPoint
\item allow PowerPoint to write to the working directory.
}

This process is a one-time operation.
}

\examples{
library(locatexec)
if (exec_available('powerpoint')) {
  file <- system.file(package = "doconv",
    "doc-examples/example.pptx")

  out <- pptx2pdf(input = file,
    output = tempfile(fileext = ".pdf"))

  if (file.exists(out)) {
    message(basename(out), " is existing now.")
  }
}
}
