% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmWithCov.r
\name{mlmWithCov}
\alias{mlmWithCov}
\title{Uses covariance/correlation matrix to calculate multivariate index of fit}
\usage{
mlmWithCov(f, x)
}
\arguments{
\item{f}{formula. Should use \code{cbind(y1,y2,...,yk)~x1+x2+..+xp}}

\item{x}{correlation/covariance matrix}
}
\value{
\item{r.squared.xy}{\eqn{R^2_{XY}} of the regression}
\item{p.squared.yx}{\eqn{P^2_{YX}} of the regression}
\item{formula}{formula provided as parameter}
\item{cov}{covariance/correlation matrix provided as parameter}
}
\description{
Calculate \eqn{R^2_{XY}} and  \eqn{P^2_{YX}} for multivariate regression
Could be used with \code{\link{dominanceAnalysis}} to
perform a multivariate dominance analysis without original
data.
}
\examples{
library(car)
cor.m<-matrix(c(
 1.0000000, 0.7951377, 0.2617168, 0.6720053, 0.3390278,
 0.7951377, 1.0000000, 0.3341037, 0.5876337, 0.3404206,
 0.2617168, 0.3341037, 1.0000000, 0.3703162, 0.2114153,
 0.6720053, 0.5876337, 0.3703162, 1.0000000, 0.3548077,
 0.3390278, 0.3404206, 0.2114153, 0.3548077, 1.0000000),
 5,5,
 byrow = TRUE,
 dimnames = list(
   c("na","ss","SAT","PPVT","Raven"),
   c("na","ss","SAT","PPVT","Raven")))
lwith<-mlmWithCov(cbind(na,ss)~SAT+PPVT+Raven,cor.m)
da<-dominanceAnalysis(lwith)
print(da)
summary(da)
}
