% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_ci.R
\name{halperin_ci}
\alias{halperin_ci}
\title{Calculate confidence interval of DOOR probability based on Halperin et al. (1989)'s method}
\usage{
halperin_ci(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  data_type = c("freq", "prop"),
  summary_obj = NULL,
  conf_level = 0.95
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if data_type = "prop"}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{summary_obj}{A object returned by \code{door_summary()}; Alternative
input for y1 and y2}

\item{conf_level}{Confidence level}
}
\value{
Halperin et al. (1989)'s CI
}
\description{
Calculate confidence interval of DOOR probability based on Halperin et al. (1989)'s method
}
\examples{
y1 = c(60, 30, 10)
y2 = c(50, 40, 10)
halperin_ci(y1, y2)

## $halperin_ci
## [1] 0.4734504 0.6147386
}
\references{
reference
}
\seealso{
\code{\link[=door_ci]{door_ci()}}
}
