% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\docType{data}
\name{latin_medical_terms}
\alias{latin_medical_terms}
\title{List of Latin medical and pharmaceutical abbreviations}
\format{
An object of class \code{character} of length 47.
}
\source{
\url{https://en.wikipedia.org/wiki/List_of_abbreviations_used_in_medical_prescriptions}
}
\usage{
latin_medical_terms
}
\description{
A named character vector. Names represent Latin terms and values the English
translations. Used for converting terms like "q4h" into "every 4 hours",
which can then be parsed into a dosage frequency/interval.
}
\details{
Use with a function like \code{\link[stringr:str_replace]{str_replace_all}}
to translate a prescription from Latin to English (thence to numbers).
}
\examples{
stringr::str_replace_all('Take two tablets q4h', latin_medical_terms)

}
\keyword{datasets}
