% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dpcr.R
\name{read_BioMark}
\alias{read_BioMark}
\title{Read BioMark}
\usage{
read_BioMark(input, ext = NULL, detailed = FALSE)
}
\arguments{
\item{input}{name of the input file (\code{character}) or input object 
(\code{data.frame}).}

\item{ext}{extension of the file ().}

\item{detailed}{logical, if \code{TRUE}, the input file is processed as if it was 
'Detailed Table Results'. In the other case, the expected input file structure is
'Summary Table Results'.}
}
\value{
An object of \code{\linkS4class{adpcr}} class.
}
\description{
Reads digital PCR data from the BioMark (Fluidigm).
}
\author{
Michal Burdukiewcz, Stefan Roediger
}
\references{
Dong, L. et al (2015). Comparison of four digital PCR platforms for accurate 
quantification of DNA copy number of a certified plasmid DNA reference material. 
Scientific Reports. 2015;5:13174.
}
\seealso{
See \code{\link{read_dpcr}} for detailed description of input files.
}
\keyword{utilities}

