% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distinct.R
\name{distinct}
\alias{distinct}
\alias{distinct_}
\title{Select distinct/unique rows.}
\usage{
distinct(.data, ...)

distinct_(.data, ..., .dots)
}
\arguments{
\item{.data}{a tbl}

\item{...}{Variables to use when determining uniqueness. If there
are multiple rows for a given combination of inputs, only the first
row will be preserved.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\description{
Retain only unique/distinct rows from an input tbl. This is an
efficient version of \code{\link{unique}}. \code{distinct()} is best-suited
for interactive use, \code{distinct_()} for calling from a function.
}
\examples{
df <- data.frame(
  x = sample(10, 100, rep = TRUE),
  y = sample(10, 100, rep = TRUE)
)
nrow(df)
nrow(distinct(df))
distinct(df, x)
distinct(df, y)

# You can also use distinct on computed variables
distinct(df, diff = abs(x - y))
}

