% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/css_class.R
\name{add_class}
\alias{add_class}
\alias{remove_class}
\alias{toggle_class}
\title{Change the state of a shiny interface element}
\usage{
add_class(ids, class_name)

remove_class(ids, class_name)

toggle_class(ids, class_name, condition = NULL)
}
\arguments{
\item{ids}{Character vector, id(s) of the element(s) to change.}

\item{class_name}{Name of the class to add/remove/toggle.}

\item{condition}{Condition to use for toggling the class.}
}
\description{
Those functions can be used to change an elements classes.
}
\note{
If you have trouble with these functions, please make sure that you
either - use any dqshiny element in your UI - load the package with
\code{\link{library}} - use \code{\link{init}} at the beginning of your UI!
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    tags$head(tags$style(".orange{background:#ff8f00}")),
    actionButton("add", "Add Class"),
    actionButton("remove", "Remove Class"),
    actionButton("toggle", "Toggle Class"),
    actionButton("toggle_cond", "Toggle Class with Condition"),
    checkboxInput("condition", "orange"),
    fluidRow(id = "row",
      dq_space(), # this is needed to make everything work
      actionButton("example", "EXAMPLE"),
      dq_space() # this is just for the alignment ;)
   )
  ),
  server = function(input, output) {
    observeEvent(input$add, add_class("row", "orange"))
    observeEvent(input$remove, remove_class("row", "orange"))
    observeEvent(input$toggle, toggle_class("row", "orange"))
    observeEvent(
      input$toggle_cond,
      toggle_class("row", "orange", input$condition)
    )
  }
)

}
}
\seealso{
Other js handler: \code{\link{enable}}, \code{\link{hide}}
}
\author{
richard.kunze
}
\concept{js handler}
