% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{IC}
\alias{IC}
\title{Obtain Inhibitory Concentrations (IC) of a dose-response curve}
\usage{
IC(object, inhib.percent)
}
\arguments{
\item{object}{Object of the class `dr4pl` for which the IC values are obtained}

\item{inhib.percent}{Inhibited percentages at which thc IC values are obtained}
}
\value{
IC values at the inhibited percentages provided by the argument 
\code{inhib.percent}
}
\description{
This function obtains estimates of the IC's of a dose-response 
curve. Typically the IC50 parameter is of interest, but sometimes IC10 or IC90
are important aspects of a dose-response curve. By controlling the function
argument, a user can obtain the IC's at various levels.
}
\examples{
data.test <- data.frame(x = c(0.0001, 0.001, 0.01, 0.1, 1),
                        y = c(10, 9, 5, 1, 0))
obj.dr4pl <- dr4pl(y ~ x,
                   data = data.test)
IC(obj.dr4pl, inhib.percent = c(10, 90))

obj.dr4pl <- dr4pl(Response ~ Dose, data = sample_data_4)  # Fit a 4PL model to data
IC(obj.dr4pl, inhib.percent = c(10, 50, 90))

}
