% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scluminex.R
\name{scluminex}
\alias{scluminex}
\title{Estimates different models for each analyte.}
\usage{
scluminex(plateid, standard, background, lfct,
    bkg = c("ignore","subtract", "include", "constraint"),
    neill.method = "finest", fmfi = "median", fec = "ec",
    fanalyte = "analyte", fwell = "well", fflag = "flag",
    verbose = TRUE, ...)
}
\arguments{
\item{plateid}{character to identify the plate}

\item{standard}{a \code{data.frame} with standard values information}

\item{background}{a \code{data.frame} with the value of the blank controls.}

\item{lfct}{a character vector of SelfStarting models for background method.
They will be used in order if no convergence is achieved, ie: the first
\code{lfct} first, if no convergence the second function, etc. Options
are \code{SSl5}, \code{SSl4} and \code{SSexp}.}

\item{bkg}{character vector specifying how the background values are
treated. Options are 'ignore', 'subtract', 'include' or 'constraint'.}

\item{neill.method}{character specifying the grouping method for the
Neill test. Default 'finest'. Other options 'c-finest', 'percentiles'
or the name of the grouping variable.}

\item{fmfi}{name of the column with MFI values}

\item{fec}{name of the column with the concentration}

\item{fanalyte}{name of the column with the name of the analyte}

\item{fwell}{name of the variable with the well information}

\item{fflag}{name of the variable with the flag to not include a
record in the standard curve estimation}

\item{verbose}{logical whether show the process of estimation.}

\item{...}{other parameters for the model}
}
\value{
A list with the following components model, convergence,
coef, data, rsquare
\itemize{
\item{\code{model}}{, the nls model}
\item{\code{convergence}}{, convergence of the model}
\item{\code{coef}}{, coefficients values for the \code{nls} model}
\item{\code{data}}{, data of the model}
\item{\code{rsquare}}{, R^2 values for the performed models}
}
}
\description{
Given a dilutions points and background \code{data.frame} estimates
a model (in a recursive way is possible)
for a background method.
}
\details{
The models are fitted by the \code{nlsLM} function from the
\code{minpack.lm} package. The background data can be ignore, or use to
subtract the values of all MFI or be included as a point in the
standard curve with a value half of the lower value of the standard points.
If two or more blank controls are specified the geometric mean of the MFI
is used. The names on the two datasets need to be the same and are
specified by the fmfi, fec and fanalyte arguments of the function. The
routine should receive the values of the MFI from the luminex fluorescence
data. Analysis is performed in logarithm scale (base 10) both for the MFI
and the concentrations.

The grouping variable for the \code{neill.method} can specified if there
are replicates of doses in the assay. If there are no replicates
one of the three 'grouping' methods can be selected.
}
\examples{
# Load data
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)$plate_1

# Fit model and summary object
igmodels <- scluminex("plate_1",sdf$standard, sdf$background,
                lfct=c("SSl4", "SSl5"),
                bkg="ignore",
                fmfi="mfi",
                verbose=FALSE)
ss <- summary(igmodels)

# Information
names(igmodels)
names(igmodels$FGF)

# Summary data
ss
as.data.frame(ss)
as.data.frame(igmodels)

# Plot the standard curve
plot(igmodels,"sc")
}

