context("clean")

test_that("clean removes depends namespace too", {
  clean(destroy = T)
  x = storr_rds(cache_path, mangle_key = TRUE)
  p = example_plan("small")
  expect_equal(x$list(), character(0))
  expect_equal(x$list("depends"), character(0))
  make(p, verbose = F)
  expect_equal(x$list(), letters[1:6])
  expect_equal(x$list("depends"), letters[1:6])
  clean(destroy = FALSE)
  expect_true(file.exists(cache_path))
  expect_equal(x$list(), character(0))
  expect_equal(x$list("depends"), character(0))
  clean(destroy = T)
  expect_false(file.exists(cache_path))
})

test_that("clean works on small example", {
  p = example_plan("small")
  expect_equal(cached(), character(0))
  expect_silent(clean(destroy=TRUE))
  expect_false(file.exists(cache_path))
  expect_silent(make(p, verbose = F))
  expect_true(file.exists(cache_path))
  expect_true(all(letters[1:6] %in% cached()))
  clean(destroy = FALSE)
  expect_true(file.exists(cache_path))
  clean(destroy=TRUE)
  expect_false(file.exists(cache_path))
  expect_equal(cached(), character(0))
  expect_false(file.exists(cache_path))
  expect_silent(clean(destroy=TRUE))
  expect_silent(clean(destroy=TRUE))
})

test_that("clean works on debug example", {
  p = example_plan("debug")
  debug_setup()
  expect_equal(cached(), character(0))
  expect_silent(clean(destroy=TRUE))
  expect_silent(clean(destroy=TRUE))
  expect_false(file.exists(cache_path))
  expect_silent(make(p, verbose = F))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_true(file.exists("e"))
  expect_true("final" %in% cached())
  expect_silent(clean(destroy=TRUE))
  expect_true(file.exists("input"))
  expect_false(file.exists("d"))
  expect_false(file.exists("e"))
  expect_equal(cached(), character(0))
  expect_false(file.exists(cache_path))
  unlink("input")
})

test_that("clean(destroy=TRUE) removes dangling files", {
  p = example_plan("debug")
  debug_setup()
  expect_equal(cached(), character(0))
  expect_silent(clean(destroy=TRUE))
  expect_silent(clean(destroy=TRUE))
  expect_false(file.exists(cache_path))
  expect_silent(make(p, verbose = F))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_true(file.exists("e"))
  expect_true("final" %in% cached())
  p$output[6] = "'new_d.rds'"
  expect_false(all(grepl("'d'", p$output)))
  expect_error(make(p, verbose = F))
  p$code[6] = "saveRDS(d, \"new_d.rds\")"
  expect_silent(make(p, verbose = F))
  expect_true(file.exists("input"))
  expect_true(file.exists("d"))
  expect_true(file.exists("e"))
  expect_true(file.exists("new_d.rds"))
  expect_true(all(c("'d'","'e'","'input'","'new_d.rds'") %in% cached()))
  clean(destroy=TRUE)
  expect_true(file.exists("input"))
  expect_false(file.exists("d"))
  expect_false(file.exists("e"))
  expect_false(file.exists("new_d.rds"))
  expect_false(file.exists(cache_path))
  unlink("input")
})

