% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timing.R
\name{build_times}
\alias{build_times}
\title{Function \code{build_times}}
\usage{
build_times(path = getwd(), search = TRUE, digits = 0,
  cache = drake::get_cache(path = path, search = search))
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{digits}{How many digits to round the times to.}

\item{cache}{storr cache for drake}
}
\value{
data.frame of times from \code{\link{system.time}}
}
\description{
List all the build times.
This doesn't include the amount of time
spent loading and saving objects!
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
build_times()
}
}
\seealso{
\code{\link{built}}
}
