% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{deps}
\alias{deps}
\title{Function deps}
\usage{
deps(x)
}
\arguments{
\item{x}{Either a function or a string.
Strings are commands from your workflow plan data frame.}
}
\value{
names of dependencies. Files wrapped in single quotes.
The other names listed are functions or generic objects.
}
\description{
List the dependencies of a function or workflow plan command.
}
\examples{
f <- function(x, y){
  out <- x + y + g(x)
  saveRDS(out, 'out.rds')
}
deps(f)
my_plan <- plan(
  x = 1 + some_object,
  my_target = x + readRDS('tracked_input_file.rds'),
  return_value = f(x, y, g(z + w))
)
deps(my_plan$command[1])
deps(my_plan$command[2])
deps(my_plan$command[3])
}
