% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_ui.R
\name{parallelism_choices}
\alias{parallelism_choices}
\title{Function \code{parallelism_choices}}
\usage{
parallelism_choices()
}
\value{
Character vector listing the types of parallel
computing supported.
}
\description{
List the types of supported parallel computing.
}
\details{
Run \code{make(..., parallelism = x, jobs = n)} for any of
the following values of \code{x} to distribute targets over parallel
units of execution.
\describe{
 \item{'parLapply'}{launches multiple processes in a single R session
 using \code{parallel::\link{parLapply}()}.
 This is single-node, (potentially) multicore computing.
 It requires more overhead than the \code{'mclapply'} option,
 but it works on Windows. If \code{jobs} is \code{1} in
 \code{\link{make}()}, then no 'cluster' is created and
 no parallelism is used.}
 \item{'mclapply'}{uses multiple processes in a single R session.
 This is single-node, (potentially) multicore computing.
 Does not work on Windows for \code{jobs > 1}
 because \code{\link{mclapply}()} is based on forking.}
 \item{'Makefile'}{uses multiple R sessions
 by creating and running a Makefile.
 For distributed computing on a cluster or supercomputer,
 try \code{\link{make}(..., parallelism = 'Makefile',
 prepend = 'SHELL=./shell.sh')}.
 You need an auxiliary \code{shell.sh} file for this,
 and \code{\link{shell_file}()}
 writes an example.

 Here, Makefile-level parallelism is only used for
 targets in your workflow plan
 data frame, not imports. To process imported objects and files,
 drake selects the best parallel
 backend for your system and uses
 the number of jobs you give to the \code{jobs}
 argument to \code{\link{make}()}.
 To use at most 2 jobs for imports and at most 4 jobs
 for targets, run
 \code{make(..., parallelism = 'Makefile', jobs = 2, args = '--jobs=4')}

 Caution: the Makefile generated by
 \code{\link{make}(..., parallelism = 'Makefile')}
 is NOT standalone. DO NOT run it outside of
\code{\link{make}()} or \code{\link{make}()}.
 Also, Windows users will need to download and intall Rtools.
}}
}
\examples{
parallelism_choices()
}
\seealso{
\code{\link{make}}, \code{\link{shell_file}}
}
