% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{configure_cache}
\alias{configure_cache}
\title{Function configure_cache}
\usage{
configure_cache(cache = drake::get_cache(),
  short_hash_algo = drake::default_short_hash_algo(cache = cache),
  long_hash_algo = drake::default_long_hash_algo(cache = cache),
  clear_progress = FALSE, overwrite_hash_algos = FALSE)
}
\arguments{
\item{cache}{cache to configure}

\item{short_hash_algo}{short hash algorithm for drake.
The short algorithm must be among \code{\link{available_hash_algos}{}},
which is just the collection of algorithms available to the `algo`
argument in \code{digest::digest()}.
See \code{?\link{default_short_hash_algo}} for more.}

\item{long_hash_algo}{short hash algorithm for drake.
The long algorithm must be among \code{\link{available_hash_algos}{}},
which is just the collection of algorithms available to the `algo`
argument in \code{digest::digest()}.
See \code{?\link{default_long_hash_algo}} for more.}

\item{clear_progress}{logical, whether to clear the recorded
build progress if this cache was used for previous calls to
\code{\link{make}()}}

\item{overwrite_hash_algos}{logical, whether to try to overwrite
the hash algorithms in the cache with any user-specified ones.}
}
\description{
configure a cache for drake. This is
to prepare the cache to be called from \code{\link{make}()}.
}
\examples{
\dontrun{
load_basic_example()
config <- make(my_plan)
cache <- config$cache
long_hash(cache)
cache <- configure_cache(
  cache = cache,
  long_hash_algo = "murmur32",
  overwrite_hash_algos = TRUE
)
long_hash(cache) # long hash algorithm. See ?default_long_hash_algorithm.
make(my_plan) # Changing the long hash puts targets out of date.
}
}
\seealso{
\code{\link{default_short_hash_algo}},
\code{\link{default_long_hash_algo}}
}
