% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_interaction.R
\name{imported}
\alias{imported}
\title{Function \code{imported}}
\usage{
imported(files_only = FALSE, path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search))
}
\arguments{
\item{files_only}{logical, whether to show imported files only
and ignore imported objects. Since all your functions and
all their global variables are imported, the full list of
imported objects could get really cumbersome.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{drake cache. See \code{\link{new_cache}()}.
If supplied, \code{path} and \code{search} are ignored.}
}
\value{
character vector naming the imported objects in the cache
}
\description{
List all the imported objects in the drake cache
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
imported()
}
}
\seealso{
\code{\link{cached}}, \code{\link{loadd}},
\code{\link{built}}
}
