% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{tracked}
\alias{tracked}
\title{List the targets and imports
that are reproducibly tracked.}
\usage{
tracked(plan = read_drake_plan(), targets = drake::possible_targets(plan),
  envir = parent.frame(), jobs = 1, verbose = drake::default_verbose())
}
\arguments{
\item{plan}{workflow plan data frame, same as for function
\code{\link[=make]{make()}}.}

\item{targets}{names of targets to build, same as for function
\code{\link[=make]{make()}}.}

\item{envir}{environment to import from, same as for function
\code{\link[=make]{make()}}.}

\item{jobs}{number of jobs/workers for parallel processing}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}
}
\value{
A character vector with the names of reproducibly-tracked targets.
}
\description{
In other words, list all the nodes
in your project's dependency network.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Load the canonical example for drake.
# List all the targets/imports that are reproducibly tracked.
tracked(my_plan)
})
}
}
