% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-graphinfo.R
\name{drake_graph_info}
\alias{drake_graph_info}
\title{Create the underlying node and edge data frames
behind \code{\link[=vis_drake_graph]{vis_drake_graph()}}.}
\usage{
drake_graph_info(config, from = NULL, mode = c("out", "in", "all"),
  order = NULL, subset = NULL, build_times = "build", digits = 3,
  targets_only = FALSE, font_size = 20, from_scratch = FALSE,
  make_imports = TRUE, full_legend = FALSE, group = NULL,
  clusters = NULL, show_output_files = TRUE, hover = FALSE)
}
\arguments{
\item{config}{A \code{\link[=drake_config]{drake_config()}} configuration list.
You can get one as a return value from \code{\link[=make]{make()}} as well.}

\item{from}{Optional collection of target/import names.
If \code{from} is nonempty,
the graph will restrict itself to
a neighborhood of \code{from}.
Control the neighborhood with
\code{mode} and \code{order}.}

\item{mode}{Which direction to branch out in the graph
to create a neighborhood around \code{from}.
Use \code{"in"} to go upstream,
\code{"out"} to go downstream,
and \code{"all"} to go both ways and disregard
edge direction altogether.}

\item{order}{How far to branch out to create
a neighborhood around \code{from}. Defaults to
as far as possible. If a target is in the neighborhood, then
so are all of its custom \code{\link[=file_out]{file_out()}} files if
\code{show_output_files} is \code{TRUE}.
That means the actual graph order may be slightly greater than
you might expect, but this ensures consistency
between \code{show_output_files = TRUE} and
\code{show_output_files = FALSE}.}

\item{subset}{Optional character vector.
Subset of targets/imports to display in the graph.
Applied after \code{from}, \code{mode}, and \code{order}.
Be advised: edges are only kept for adjacent nodes in \code{subset}.
If you do not select all the intermediate nodes,
edges will drop from the graph.}

\item{build_times}{Character string or logical.
If character, the choices are
1. \code{"build"}: runtime of the command plus the time
it take to store the target or import.
2. \code{"command"}: just the runtime of the command.
3. \code{"none"}: no build times.
If logical, \code{build_times} selects whether to show the
times from `build_times(..., type = "build")`` or use
no build times at all. See \code{\link[=build_times]{build_times()}} for details.}

\item{digits}{Number of digits for rounding the build times}

\item{targets_only}{Logical,
whether to skip the imports and only include the
targets in the workflow plan.}

\item{font_size}{Numeric, font size of the node labels in the graph}

\item{from_scratch}{Logical, whether to assume all the targets
will be made from scratch on the next \code{\link[=make]{make()}}.
Makes all targets outdated, but keeps information about
build progress in previous \code{\link[=make]{make()}}s.}

\item{make_imports}{Logical, whether to make the imports first.
Set to \code{FALSE} to increase speed and risk using obsolete information.}

\item{full_legend}{Logical. If \code{TRUE}, all the node types
are printed in the legend. If \code{FALSE}, only the
node types used are printed in the legend.}

\item{group}{Optional character scalar, name of the column used to
group nodes into columns. All the columns names of your \code{config$plan}
are choices. The other choices (such as \code{"status"}) are column names
in the \code{nodes} . To group nodes into clusters in the graph,
you must also supply the \code{clusters} argument.}

\item{clusters}{Optional character vector of values to cluster on.
These values must be elements of the column of the \code{nodes} data frame
that you specify in the \code{group} argument to \code{drake_graph_info()}.}

\item{show_output_files}{Logical, whether to include
\code{\link[=file_out]{file_out()}} files in the graph.}

\item{hover}{Logical, whether to show text (file contents,
commands, etc.) when you hover your cursor over a node.}
}
\value{
A list of three data frames: one for nodes,
one for edges, and one for
the legend nodes. The list also contains the
default title of the graph.
}
\description{
With the returned data frames,
you can plot your own custom \code{visNetwork} graph.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (requireNamespace("visNetwork", quietly = TRUE)) {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan) # my_plan loaded with load_mtcars_example()
vis_drake_graph(config) # Jump straight to the interactive graph.
# Get a list of data frames representing the nodes, edges,
# and legend nodes of the visNetwork graph from vis_drake_graph().
raw_graph <- drake_graph_info(config = config)
# Choose a subset of the graph.
smaller_raw_graph <- drake_graph_info(
  config = config,
  from = c("small", "reg2"),
  mode = "in"
)
# Inspect the raw graph.
str(raw_graph)
# Use the data frames to plot your own custom visNetwork graph.
# For example, you can omit the legend nodes
# and change the direction of the graph.
library(visNetwork)
graph <- visNetwork(nodes = raw_graph$nodes, edges = raw_graph$edges)
visHierarchicalLayout(graph, direction = 'UD')
# Optionally visualize clusters.
config$plan$large_data <- grepl("large", config$plan$target)
graph <- drake_graph_info(
  config, group = "large_data", clusters = c(TRUE, FALSE))
tail(graph$nodes)
render_drake_graph(graph)
# You can even use clusters given to you for free in the `graph$nodes`
# data frame.
graph <- drake_graph_info(
  config, group = "status", clusters = "imported")
tail(graph$nodes)
render_drake_graph(graph)
}
}
})
}
}
\seealso{
\code{\link[=vis_drake_graph]{vis_drake_graph()}}
}
