% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{plan_to_notebook}
\alias{plan_to_notebook}
\title{Turn a \code{drake} plan into an R notebook.
\lifecycle{questioning}}
\usage{
plan_to_notebook(plan, con)
}
\arguments{
\item{plan}{Workflow plan data frame. See \code{\link[=drake_plan]{drake_plan()}}
for details.}

\item{con}{A file path or connection to write to.}
}
\description{
\code{code_to_plan()}, \code{\link[=plan_to_code]{plan_to_code()}}, and
\code{\link[=plan_to_notebook]{plan_to_notebook()}} together illustrate the relationships
between \code{drake} plans, R scripts, and R Markdown documents.
In the file generated by \code{plan_to_code()}, every target/command pair
becomes a chunk of code.
Targets are arranged in topological order
so dependencies are available before their downstream targets.
Please note:
\enumerate{
\item You are still responsible for loading your project's
packages, imported functions, etc.
\item Triggers disappear.
}
}
\examples{
if (suppressWarnings(require("knitr"))) {
plan <- drake_plan(
  raw_data = read_excel(file_in("raw_data.xlsx")),
  data = raw_data,
  hist = create_plot(data),
  fit = lm(Ozone ~ Temp + Wind, data)
)
file <- tempfile()
# Turn the plan into an R notebook a the given file path.
plan_to_notebook(plan, file)
# Here is what the script looks like.
cat(readLines(file), sep = "\n")
# Convert back to a drake plan.
code_to_plan(file)
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}, \code{\link[=code_to_plan]{code_to_plan()}},
\code{\link[=plan_to_code]{plan_to_code()}}
}
