% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate_storr.R
\name{file_store}
\alias{file_store}
\title{Show a file's encoded representation in the cache
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
file_store(x)
}
\arguments{
\item{x}{Character string to be turned into a filename
understandable by drake (i.e., a string with literal
single quotes on both ends).}
}
\value{
A single-quoted character string: i.e., a filename
understandable by drake.
}
\description{
This function simply wraps literal double quotes around
the argument \code{x} so \code{drake} knows it is the name of a file.
Use when you are calling functions like \code{deps_code()}: for example,
\code{deps_code(file_store("report.md"))}. See the examples for details.
Internally, \code{drake} wraps the names of file targets/imports
inside literal double quotes to avoid confusion between
files and generic R objects.
}
\examples{
# Wraps the string in single quotes.
file_store("my_file.rds") # "'my_file.rds'"
\dontrun{
isolate_example("contain side effects", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the workflow to build the targets
list.files() # Should include input "report.Rmd" and output "report.md".
head(readd(small)) # You can use symbols for ordinary objects.
# But if you want to read cached info on files, use `file_store()`.
readd(file_store("report.md"), character_only = TRUE) # File fingerprint.
deps_code(file_store("report.Rmd"))
config <- drake_config(my_plan)
deps_profile(
  file_store("report.Rmd"),
  config = config,
  character_only = TRUE
)
}
})
}
}
