% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drda-package.R
\docType{package}
\name{drda-package}
\alias{drda-package}
\title{Dose-response data analysis}
\description{
\code{drda} is a package for fitting (log-)logistic curves and performing
dose-response data analysis.
}
\section{Available functions}{


Functions specific to \code{drda}:

\itemize{
\item{\code{drda}: main function for fitting observed data.}
\item{\code{logistic2_fn}: 2-parameter logistic function.}
\item{\code{logistic4_fn}: 4-parameter logistic function.}
\item{\code{logistic5_fn}: 5-parameter logistic function.}
\item{\code{logistic6_fn}: 6-parameter logistic function.}
\item{\code{gompertz_fn}: Gompertz function.}
\item{\code{loglogistic2_fn}: 2-parameter log-logistic function.}
\item{\code{loglogistic4_fn}: 4-parameter log-logistic function.}
\item{\code{loglogistic5_fn}: 5-parameter log-logistic function.}
\item{\code{loglogistic6_fn}: 6-parameter log-logistic function.}
\item{\code{loggompertz_fn}: log-Gompertz function.}
\item{\code{nauc}: normalized area under the curve.}
\item{\code{naac}: normalized area above the curve.}
}

Functions expected for an object fit:

\itemize{
\item{\code{anova}: compare model fits.}
\item{\code{deviance}: residual sum of squares of the model fit.}
\item{\code{logLik}: value of the log-likelihood function associated to the
model fit.}
\item{\code{plot}: plotting function.}
\item{\code{predict}: model predictions.}
\item{\code{print}: basic model summaries.}
\item{\code{residuals}: model residuals.}
\item{\code{sigma}: residual standard deviation.}
\item{\code{summary}: fit summaries.}
\item{\code{vcov}: approximate variance-covariance matrix of model parameters.}
\item{\code{weights}: model weights.}
}
}

\references{
Malyutina A, Tang J, Pessia A (2023). drda: An R package for
dose-response data analysis using logistic functions. Journal of
Statistical Software, 106(4), 1-26. doi:10.18637/jss.v106.i04
}
