% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{setDreamerr_dev.mode}
\alias{setDreamerr_dev.mode}
\title{Sets the developer mode to help form check_arg calls}
\usage{
setDreamerr_dev.mode(dev.mode = FALSE)
}
\arguments{
\item{dev.mode}{A logical, default is \code{FALSE}.}
}
\description{
Turns on/off a full fledged checking of calls to \code{\link[dreamerr]{check_arg}}. If on, it enables the developer mode which checks extensively calls to check_arg, allowing to find any problem. If a problem is found, it is pinpointed and the associated help is referred to.
}
\details{
Since this mode ensures a detailed cheking of all \code{\link[dreamerr]{check_arg}} calls, it is thus a strain on performance and should be always turned off otherwise needed.
}
\examples{

# If you're new to check_arg, given the many types available,
# it's very common to make mistakes when creating check_arg calls.
# The developer mode ensures that any problematic call is spotted
# and the problem is clearly stated
#
# Note that since this mode ensures a detailed cheking of the call
# it is thus a strain on performance and should be always turned off
# otherwise needed.
#

# Setting the developer mode on:
setDreamerr_dev.mode(TRUE)

# Creating some 'wrong' calls => the problem is pinpointed

test = function(x) check_arg(x, "integer scalar", "numeric vector")
try(test())

test = function(...) check_arg("numeric vector", ...)
try(test())

test = function(x) check_arg(x$a, "numeric vector")
try(test())

test = function(x) check_arg(x, "numeric vector integer")
try(test())

test = function(x) check_arg(x, "vector len(,)")
try(test())

# etc...

# Setting the developer mode off:
setDreamerr_dev.mode(FALSE)


}
\seealso{
\code{\link[dreamerr]{check_arg}}
}
\author{
Laurent Berge
}
