% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmm.R
\name{bic.dmm}
\alias{bic.dmm}
\title{Evaluate the BIC of a drifting Markov Model}
\usage{
\method{bic}{dmm}(x, sequences, ncpu = 2)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{sequences}{A character vector or a list of character vector representing the sequences for which the BIC will be computed based on \code{x}.}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A list of BIC (numeric).
}
\description{
Computation of the Bayesian Information Criterion.
}
\examples{
data(lambda, package = "drimmR")
sequence <- c("a","g","g","t","c","g","a","t","a","a","a")
dmm<- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
bic(dmm,sequence)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{loglik}, \link[drimmR]{bic}
}
\author{
Victor Mataigne, Alexandre Seiller
}
