% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmean_fn.R
\name{estimate_ci_wmean}
\alias{estimate_ci_wmean}
\title{Compute confidence interval/s for the weight mean parameters}
\usage{
estimate_ci_wmean(
  out,
  treat,
  covar,
  wmean_est,
  alpha = 0.05,
  out_levels = order(unique(out)),
  out_form = NULL,
  out_weights = rep(1, length(out_levels)),
  out_model,
  treat_form = "1",
  ci = c("bca", "wald"),
  nboot = 10000
)
}
\arguments{
\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{wmean_est}{The point estimates for weighted means}

\item{alpha}{Confidence intervals have nominal level 1-\code{alpha}.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{out_weights}{A vector of \code{numeric} weights with length equal to the length 
of \code{out_levels}.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{ci}{A vector of \code{characters} indicating which confidence intervals
should be computed (\code{"bca"} and/or \code{"wald"})}

\item{nboot}{Number of bootstrap replicates used to compute bootstrap confidence
intervals.}
}
\value{
List with \code{wald} and \code{bca}-estimated confidence intervals 
for the weighted mean parameters.
}
\description{
Compute confidence interval/s for the weight mean parameters
}
