% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDI.R
\name{MDI}
\alias{MDI}
\title{Compute the multivariate drought index}
\usage{
MDI(X, Y, ts = 6)
}
\arguments{
\item{X}{is The vector of a monthly hydro-climatic variable of n years.}

\item{Y}{is The vector of a monthly hydro-climatic variable of n years.}

\item{ts}{is the accumulated time scale.}
}
\value{
The multivariate drought index of different time scales from the marginal probability (or percentile)
}
\description{
Based on the vector of a monthly hydro-climatic variable, 
the multivariate drought index is computed based on the marginal (or univariate) probability (or percentile) from the function SDI.
}
\examples{

X=runif(120, min = 0, max = 100)
Y=runif(120, min = 0, max = 100)
fit<-MDI(X,Y,ts=6) # Compute the 6 month drought index
fit$ProbEmp2 #Get the empirival drought index

}
