% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dose_observed.R
\name{f_dose_observed}
\alias{f_dose_observed}
\title{Summarize Observed Drug Dispensing Data}
\usage{
f_dose_observed(df = NULL, visitview = NULL, showplot = TRUE)
}
\arguments{
\item{df}{A data frame for subject-level enrollment and event data,
including the following variables:
\code{trialsdt}, \code{usubjid}, \code{randdt},
\code{treatment}, \code{treatment_description},
\code{time}, \code{event}, \code{dropout}, and \code{cutoffdt}.}

\item{visitview}{A data frame containing the observed drug dispensing
data, including the following variables:
\code{usubjid}, \code{visit}, \code{date}, \code{drug},
\code{drug_name}, \code{dose_unit}, \code{kit_number}, and
\code{dispensed_quantity}.}

\item{showplot}{A Boolean variable that controls whether or not to
show the drug dispensing model fit and drug demand prediction
plots. It defaults to \code{TRUE}.}
}
\value{
A list with the following components:
\itemize{
\item \code{trialsdt}: The trial start date.
\item \code{cutoffdt}: The cutoff date.
\item \code{vf}: A data frame for subject-level drug dispensing data,
including the following variables: \code{drug}, \code{drug_name},
\code{dose_unit}, \code{usubjid}, \code{treatment},
\code{treatment_description}, \code{arrivalTime}, \code{time},
\code{event}, \code{dropout}, \code{day}, \code{dose},
\code{cum_dose}, and \code{row_id}.
\item \code{treatment_by_drug_df}: A data frame indicating the
treatments associated with each drug, including the following variables:
\code{treatment}, \code{drug}, \code{drug_name}, and \code{dose_unit}.
\item \code{dosing_summary_t}: A data frame for the cumulative doses
dispensed by each observed time point. It contains the following
variables: \code{drug}, \code{drug_name}, \code{dose_unit},
\code{t}, \code{n}, \code{lower}, \code{upper}, \code{mean},
and \code{var}, where \code{lower} and \code{upper} have missing
values, \code{mean = n}, and \code{var = 0}.
\item \code{dosing_summary_t0}: A data frame for the cumulative doses
dispensed before the cutoff date. It contains the following
variables: \code{drug}, \code{drug_name}, \code{dose_unit},
and \code{cum_dose_t0}.
\item \code{cum_dispense_plot}: The step plot for the cumulative doses
dispensed for each drug.
\item \code{bar_t0_plot}: The bar chart for the gap time between
randomization and the first drug dispensing visit.
\item \code{bar_ti_plot}: The bar chart for the gap time between two
consecutive drug dispensing visits.
\item \code{bar_di_plot}: The bar chart for the dispensed doses at drug
dispensing visits.
}
}
\description{
Provides an overview of the observed drug dispensing data,
including the trial start date, data cutoff date, cumulative number
of doses dispensed by drug, bar chart of the gap time between randomization
and the first drug dispensing visit, bar chart of the gap time between
two consecutive drug dispensing visits, and bar chart of the
dispensed doses at drug dispensing visits by drug.
}
\examples{

\donttest{
dose_observed <- f_dose_observed(df = df2, visitview = visitview2)
}

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
