% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_original.R
\name{get_original}
\alias{get_original}
\title{Get Original Time Series}
\usage{
get_original(daily.object, forecast = FALSE)
}
\arguments{
\item{daily.object}{Output from dsa}

\item{forecast}{Include forecast of component}
}
\description{
Get the original time series from a seasonal adjustment object created by the dsa function. Can deviate from the input data as missings are filled up, usually using zoo::na.locf().
}
\examples{
set.seed(123)
x = daily_sim(n=4)$original # series with length 4 years
res <- dsa(x, cval=7, model=c(3,1,0),fourier_number = 13, reg.create=NULL) 
get_original(res)
}
\seealso{
get_sa, get_trend
}
\author{
Daniel Ollech
}
