% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dspoint.R
\name{dspoint}
\alias{dspoint}
\title{Individual points of interest.}
\usage{
dspoint(x, y, label = "", pch = 21, size = 2, col = "blue",
  regionCol = NULL, image = "", offset = c(0, 0.5), display = TRUE,
  fixed = FALSE, iters = 0, attractor = FALSE, crop = TRUE,
  artificial = FALSE, ...)
}
\arguments{
\item{x}{The x-coordinate of the point.}

\item{y}{The y-coordinate of the point.}

\item{label}{A string label. Text will appear above the dot by default.
Please see the \code{offset} parameter to adjust.}

\item{pch}{Plotting 'character' or symbol to use, default is 21 (filled circle). See \code{help(pch)} for details.}

\item{size}{Determines the size of the point.}

\item{col}{A string color for the point.
Use "NA" or "" to hide the point. See also \code{display}.}

\item{regionCol}{An alternate color used to define the color of the region for
\code{\link{guessregions}()}. Defaults to \code{col} or \code{col[1]}.}

\item{image}{A single color as a string, or a vector of colors as a string.
See details for more information.}

\item{offset}{This will offset the label. Enter as \code{c(x, y)}.}

\item{display}{Set display = FALSE to hide the dot, but still add to your system.
Mostly useful for \code{\link{guessregions}()}.}

\item{fixed}{A flag to declare a fixed point. The image of any fixed
point is should be the original point.}

\item{iters}{Determines the number of iterations of the function when making a color gradient.
Use \code{col = color1, image = color2, iters = n} to create a gradient of colors between
color1 and color2. See details for more information.}

\item{attractor}{A flag to delcare a point as an attractor: a fixed point for the function that
other points converge to. Used in \code{\link{guessregions}()}.}

\item{crop}{If \code{crop==TRUE} points outside of defined range will be cropped,
and no further images will be calculated.}

\item{artificial}{For internal use.}

\item{...}{Extra graphical parameters to be sent through \code{points}}
}
\description{
\code{pnt} and \code{dspoint} are the same function.
This function takes a single point and creates an object displaying the point, and optionally
it's behavior throughout iterations of the system.
}
\section{Images of the point}{


The \code{dspoint} object begins with an initial point. Images of the point may be displayed in three ways.

If the \code{image} parameter is a single color and \code{iters} is not set, then \code{dspoint} will calculate and display
the image of the point under the model's function in that color.

If the \code{image}  parameter is a vector of k colors, then \code{dspoint} calculates and
displays k successive images of the point using those colors.
The string "NA" may be used to avoid displaying an iteration.

If the \code{image} parameter is a single color and \code{iters} is defined, then \code{iters}
successive images are displayed, using a gradient between \code{col} and \code{image}.

In most cases, rather than specifying \code{col} and \code{image} separately, they may be
combined into a single vector.
}
\examples{
library(dsmodels)

fun <- function(X,Y) {
  list(
    X/exp(Y),
    Y/exp(X)
  )
}

model <- dsmodel(fun, title = "A Single Point")
model + dsrange(3,3, discretize = .09) +
	dspoint(1,2, col = "magenta")

dsmodel(fun, title = "A Point and a Label") +
 dsrange(3,3, discretize = .09) +
 dspoint(2.2, 2.1, label = "point!", col = "green")

dsmodel(fun, title = "A Point and Iterations of that Point") +
 dsrange(3,3, discretize = .09) +
	dspoint(1,1, col = "red", image = c("orange","yellow"))

dsmodel(fun, title = "Iterations of a Point over a Color Gradient") +
 dsrange(3,3, discretize = .09) +
	dspoint(0.2, 0.5, image = "pink", iters = 3, col = "grey")
}

