% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twdtw_reduce_time.R
\name{twdtw_reduce_time}
\alias{twdtw_reduce_time}
\title{Fast TWDTW apply}
\usage{
twdtw_reduce_time(x, y, weight.fun = NULL, dist.method = "Euclidean",
  step.matrix = symmetric1, from = NULL, to = NULL, by = NULL,
  overlap = 0.5, fill = 255)
}
\arguments{
\item{x}{a data.frame with the target time series. Usually, it is an unclassified time series. 
It must contain two or more columns, one column called \code{date} with dates in the format 
"YYYY-MM-DD". The other columns can have any names (e.g., red, blue, nir, evi, ndvi) as long 
as they match the column names in the temporal patterns \code{y}.}

\item{y}{a list of data.frama objects similar to \code{x}. 
The temporal patterns used to classify the time series in \code{x}.}

\item{weight.fun}{A function. Any function that receives and performs a 
computation on a matrix. The function receives a matrix of time differences 
in days and returns a matrix of time-weights. If not declared the time-weight 
is zero. In this case the function runs the standard version of the dynamic 
time warping. See details.}

\item{dist.method}{A character. Method to derive the local cost matrix.
Default is ''Euclidean'' see \code{\link[proxy]{dist}} in package 
\pkg{proxy}.}

\item{step.matrix}{See \code{\link[dtw]{stepPattern}} in package \pkg{dtw} 
\insertCite{Giorgino:2009}{dtwSat}.}

\item{from}{A character or \code{\link[base]{Dates}} object in the format "yyyy-mm-dd".}

\item{to}{A \code{\link[base]{character}} or \code{\link[base]{Dates}} object in the format "yyyy-mm-dd".}

\item{by}{A \code{\link[base]{character}} with the interval size, \emph{e.g.} "6 month".}

\item{overlap}{A number between 0 and 1. The minimum overlapping 
between one match and the interval of classification. Default is 0.5, 
\emph{i.e.} an overlap minimum of 50\%.}

\item{fill}{An integer to fill the classification gaps.}
}
\description{
This function is a faster version of \link[dtwSat]{twdtwApply} (usually 3x faster). 
It does not keep any intermediate data. It performs a multidimensional TWDTW analysis 
\insertCite{Maus:2019}{dtwSat} and retrieves only the best matches between the unclassified 
time series and the patterns for each defined time interval.
}
\examples{
\dontrun{

library(dtwSat)
log_fun = logisticWeight(-0.1, 50)
from = "2009-09-01"
to = "2017-09-01"
by = "12 month"

# S4 objects for original implementation 
tw_patt = readRDS(system.file("lucc_MT/patterns/patt.rds", package = "dtwSat"))
tw_ts = twdtwTimeSeries(MOD13Q1.ts) 

# Table from csv for minimalist version 
mn_patt <- lapply(dir(system.file("lucc_MT/patterns", package = "dtwSat"), 
  pattern = ".csv$", full.names = TRUE), read.csv, stringsAsFactors = FALSE)
mn_ts <- read.csv(system.file("reduce_time/ts_MODIS13Q1.csv", package = "dtwSat"), 
  stringsAsFactors = FALSE)

# Benchtmark 
rbenchmark::benchmark(
  original = twdtwClassify(twdtwApply(x = tw_ts, y = tw_patt, weight.fun = log_fun), 
                                      from = from, to = to, by = by)[[1]],
  minimalist = twdtw_reduce_time(x = mn_ts, y = mn_patt, weight.fun = log_fun, 
                                      from = from, to = to, by = by)  
 )
}

}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
