% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearWeight.R
\docType{methods}
\name{linearWeight}
\alias{linearWeight}
\title{Linear weight function}
\usage{
linearWeight(a, b = 0)
}
\arguments{
\item{a}{numeric. The slop of the line.}

\item{b}{numeric. The intercept of the line.}
}
\value{
A \code{\link[base]{function}} object.
}
\description{
Builds a linear time weight 
function to compute the TWDTW local cost matrix [1].
}
\details{
The linear \code{linearWeight} and \code{logisticWeight} weight functions 
can be passed to \code{\link[dtwSat]{twdtwApply}} through the argument \code{weight.fun}.
This will add a time-weight to the dynamic time warping analysis. The time weight 
creates a global constraint useful to analyse time series with phenological cycles
of vegetation that are usually bound to seasons. In previous studies by 
\insertCite{Maus:2016;textual}{dtwSat} the logistic weight had better results than the 
linear for land cover classification. See \insertCite{Maus:2016;textual}{dtwSat} and 
\insertCite{Maus:2019;textual}{dtwSat}.
}
\examples{
lin_fun = linearWeight(a=0.1)
lin_fun

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[dtwSat]{twdtwApply}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
