# Generated by duckplyr's 05-duckdb-tests.R, do not edit by hand

# anti_join order-preserving -----------------------------------------------------------

test_that("relational anti_join(join_by(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "anti_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "anti_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "anti_join"
  rel6 <- rel_join(
    rel5,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel5), expr_reference("a", rel4)))
    ),
    "anti"
  )
  "anti_join"
  rel7 <- rel_order(rel6, list(expr_reference("___row_number_x", rel5)))
  "anti_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel8
  out <- rel_to_altrep(rel8)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# anti_join order-enforcing ------------------------------------------------------------

test_that("relational anti_join(join_by(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "anti_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "anti_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- rel_join(
    rel2,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel2), expr_reference("a", rel4)))
    ),
    "anti"
  )
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("a"), expr_reference("b")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# arrange order-preserving -------------------------------------------------------------

test_that("relational arrange() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  rel1
  out <- rel_to_altrep(rel1)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("a"), expr_reference("___row_number")))
  "arrange"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("g"), expr_reference("___row_number")))
  "arrange"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g, a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("g"), expr_reference("a"), expr_reference("___row_number"))
  )
  "arrange"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a, g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("g"), expr_reference("___row_number"))
  )
  "arrange"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# arrange order-enforcing --------------------------------------------------------------

test_that("relational arrange() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_order(rel1, list(expr_reference("a")))
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_order(rel1, list(expr_reference("g")))
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g, a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_order(rel1, list(expr_reference("g"), expr_reference("a")))
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a, g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_order(rel1, list(expr_reference("a"), expr_reference("g")))
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# count order-preserving ---------------------------------------------------------------

test_that("relational count() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      a = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), n = rep(1L, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(b = 2, n = 6L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g, a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      a = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), n = rep(1L, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b, g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(b = rep(2, 3L), g = 1:3, n = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# count order-enforcing ----------------------------------------------------------------

test_that("relational count() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("n")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      a = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a"), expr_reference("n")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), n = rep(1L, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("b"), expr_reference("n")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(b = 2, n = 6L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("g"), expr_reference("n")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g, a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      a = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("g"), expr_reference("a"), expr_reference("n"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), n = rep(1L, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b, g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- rel_order(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("b"), expr_reference("g"), expr_reference("n"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(b = rep(2, 3L), g = 1:3, n = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# distinct order-preserving ------------------------------------------------------------

test_that("relational distinct() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            },
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a, b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(b, b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(b = 2)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 3, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_filter(
    rel9,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- rel_order(rel10, list(expr_reference("___row_number")))
  "distinct"
  rel12 <- rel_project(
    rel11,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 4, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_filter(
    rel9,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- rel_order(rel10, list(expr_reference("___row_number")))
  "distinct"
  rel12 <- rel_project(
    rel11,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 5, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_filter(
    rel9,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- rel_order(rel10, list(expr_reference("___row_number")))
  "distinct"
  rel12 <- rel_project(
    rel11,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 6, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_filter(
    rel9,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- rel_order(rel10, list(expr_reference("___row_number")))
  "distinct"
  rel12 <- rel_project(
    rel11,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 7, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_filter(
    rel9,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- rel_order(rel10, list(expr_reference("___row_number")))
  "distinct"
  rel12 <- rel_project(
    rel11,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g, .keep_all = TRUE) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = c(1, 2, 4), b = rep(2, 3L), g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# distinct order-enforcing -------------------------------------------------------------

test_that("relational distinct() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_distinct(rel1)
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      a = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a, b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      a = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      b = {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a"), expr_reference("b")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(b, b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      b = {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("b")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(b = 2)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("g")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 3, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- rel_distinct(rel4)
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("g")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 4, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- rel_distinct(rel4)
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("g")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 5, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- rel_distinct(rel4)
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("g")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 6, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- rel_distinct(rel4)
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("g")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 7, g = 2L)

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- rel_distinct(rel4)
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("g")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g, .keep_all = TRUE) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- expr_reference("g")
              expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- rel_filter(
    rel3,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- rel_order(rel4, list(expr_reference("___row_number")))
  "distinct"
  rel6 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel7 <- rel_order(
    rel6,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel7
  out <- rel_to_altrep(rel7)
  expect_identical(
    out,
    data.frame(a = c(1, 2, 4), b = rep(2, 3L), g = 1:3)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# filter order-preserving --------------------------------------------------------------

test_that("relational filter(a == 1) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- rel_filter(
    rel2,
    list(
      expr_function(
        "==",
        list(
          expr_reference("a"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1, experimental = experimental)
          } else {
            expr_constant(1)
          }
        )
      )
    )
  )
  "filter"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "filter"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = 1, b = 2, g = 1L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3, g == 2) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- rel_filter(
    rel2,
    list(
      expr_function(
        "___coalesce",
        list(
          expr_function(
            "|",
            list(
              expr_function(
                "r_base::==",
                list(
                  expr_reference("a"),
                  if ("experimental" %in% names(formals(expr_constant))) {
                    expr_constant(2L, experimental = experimental)
                  } else {
                    expr_constant(2L)
                  }
                )
              ),
              expr_function(
                "r_base::==",
                list(
                  expr_reference("a"),
                  if ("experimental" %in% names(formals(expr_constant))) {
                    expr_constant(3L, experimental = experimental)
                  } else {
                    expr_constant(3L)
                  }
                )
              )
            )
          ),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(FALSE, experimental = experimental)
          } else {
            expr_constant(FALSE)
          }
        )
      ),
      expr_function(
        "==",
        list(
          expr_reference("g"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          }
        )
      )
    )
  )
  "filter"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "filter"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = c(2, 2), g = c(2L, 2L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3 & g == 2) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "&"(x, y) AS (x AND y)'))
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- rel_filter(
    rel2,
    list(
      expr_function(
        "&",
        list(
          expr_function(
            "___coalesce",
            list(
              expr_function(
                "|",
                list(
                  expr_function(
                    "r_base::==",
                    list(
                      expr_reference("a"),
                      if ("experimental" %in% names(formals(expr_constant))) {
                        expr_constant(2L, experimental = experimental)
                      } else {
                        expr_constant(2L)
                      }
                    )
                  ),
                  expr_function(
                    "r_base::==",
                    list(
                      expr_reference("a"),
                      if ("experimental" %in% names(formals(expr_constant))) {
                        expr_constant(3L, experimental = experimental)
                      } else {
                        expr_constant(3L)
                      }
                    )
                  )
                )
              ),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(FALSE, experimental = experimental)
              } else {
                expr_constant(FALSE)
              }
            )
          ),
          expr_function(
            "==",
            list(
              expr_reference("g"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "filter"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "filter"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = c(2, 2), g = c(2L, 2L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a != 2 | g != 2) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "!="(x, y) AS "r_base::!="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- rel_filter(
    rel2,
    list(
      expr_function(
        "|",
        list(
          expr_function(
            "!=",
            list(
              expr_reference("a"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          ),
          expr_function(
            "!=",
            list(
              expr_reference("g"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "filter"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "filter"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = c(1, 3, 4, 5, 6), b = rep(2, 5L), g = c(1L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# filter order-enforcing ---------------------------------------------------------------

test_that("relational filter(a == 1) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_filter(
    rel1,
    list(
      expr_function(
        "==",
        list(
          expr_reference("a"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1, experimental = experimental)
          } else {
            expr_constant(1)
          }
        )
      )
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = 1, b = 2, g = 1L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3, g == 2) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_filter(
    rel1,
    list(
      expr_function(
        "___coalesce",
        list(
          expr_function(
            "|",
            list(
              expr_function(
                "r_base::==",
                list(
                  expr_reference("a"),
                  if ("experimental" %in% names(formals(expr_constant))) {
                    expr_constant(2L, experimental = experimental)
                  } else {
                    expr_constant(2L)
                  }
                )
              ),
              expr_function(
                "r_base::==",
                list(
                  expr_reference("a"),
                  if ("experimental" %in% names(formals(expr_constant))) {
                    expr_constant(3L, experimental = experimental)
                  } else {
                    expr_constant(3L)
                  }
                )
              )
            )
          ),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(FALSE, experimental = experimental)
          } else {
            expr_constant(FALSE)
          }
        )
      ),
      expr_function(
        "==",
        list(
          expr_reference("g"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          }
        )
      )
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = c(2, 2), g = c(2L, 2L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3 & g == 2) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "&"(x, y) AS (x AND y)'))
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_filter(
    rel1,
    list(
      expr_function(
        "&",
        list(
          expr_function(
            "___coalesce",
            list(
              expr_function(
                "|",
                list(
                  expr_function(
                    "r_base::==",
                    list(
                      expr_reference("a"),
                      if ("experimental" %in% names(formals(expr_constant))) {
                        expr_constant(2L, experimental = experimental)
                      } else {
                        expr_constant(2L)
                      }
                    )
                  ),
                  expr_function(
                    "r_base::==",
                    list(
                      expr_reference("a"),
                      if ("experimental" %in% names(formals(expr_constant))) {
                        expr_constant(3L, experimental = experimental)
                      } else {
                        expr_constant(3L)
                      }
                    )
                  )
                )
              ),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(FALSE, experimental = experimental)
              } else {
                expr_constant(FALSE)
              }
            )
          ),
          expr_function(
            "==",
            list(
              expr_reference("g"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = c(2, 2), g = c(2L, 2L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a != 2 | g != 2) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "!="(x, y) AS "r_base::!="(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- rel_filter(
    rel1,
    list(
      expr_function(
        "|",
        list(
          expr_function(
            "!=",
            list(
              expr_reference("a"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          ),
          expr_function(
            "!=",
            list(
              expr_reference("g"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = c(1, 3, 4, 5, 6), b = rep(2, 5L), g = c(1L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# full_join order-preserving -----------------------------------------------------------

test_that("relational full_join(join_by(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "full_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "full_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "full_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "full_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "full_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "full_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "full_join"
  rel7 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a_x")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "full_join"
  rel8 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a_y")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "full_join"
  rel9 <- rel_join(
    rel7,
    rel8,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
    ),
    "outer"
  )
  "full_join"
  rel10 <- rel_order(
    rel9,
    list(expr_reference("___row_number_x", rel7), expr_reference("___row_number_y", rel8))
  )
  "full_join"
  rel11 <- rel_project(
    rel10,
    list(
      {
        tmp_expr <- expr_function("___coalesce", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 1:5, b.x = rep(c(2, NA), c(4L, 1L)), b.y = rep(c(NA, 2), c(1L, 4L)))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# full_join order-enforcing ------------------------------------------------------------

test_that("relational full_join(join_by(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "full_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "full_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "full_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "full_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "full_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "full_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "full_join"
  rel7 <- rel_join(
    rel5,
    rel6,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
    ),
    "outer"
  )
  "full_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_function("___coalesce", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- rel_order(
    rel8,
    list(expr_reference("a"), expr_reference("b.x"), expr_reference("b.y"))
  )
  rel9
  out <- rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 1:5, b.x = rep(c(2, NA), c(4L, 1L)), b.y = rep(c(NA, 2), c(1L, 4L)))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# inner_join order-preserving ----------------------------------------------------------

test_that("relational inner_join(join_by(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "inner_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "inner_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "inner_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "inner_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "inner_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel7 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a_x")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel8 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a_y")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel9 <- rel_join(
    rel7,
    rel8,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
    ),
    "inner"
  )
  "inner_join"
  rel10 <- rel_order(
    rel9,
    list(expr_reference("___row_number_x", rel7), expr_reference("___row_number_y", rel8))
  )
  "inner_join"
  rel11 <- rel_project(
    rel10,
    list(
      {
        tmp_expr <- expr_function("___coalesce", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 2:4, b.x = rep(2, 3L), b.y = rep(2, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# inner_join order-enforcing -----------------------------------------------------------

test_that("relational inner_join(join_by(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "inner_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "inner_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "inner_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "inner_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "inner_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel7 <- rel_join(
    rel5,
    rel6,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
    ),
    "inner"
  )
  "inner_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_function("___coalesce", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- rel_order(
    rel8,
    list(expr_reference("a"), expr_reference("b.x"), expr_reference("b.y"))
  )
  rel9
  out <- rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 2:4, b.x = rep(2, 3L), b.y = rep(2, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# intersect order-preserving -----------------------------------------------------------

test_that("relational intersect() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "semi_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "semi_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "semi_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "semi_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "semi_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "semi_join"
  rel6 <- rel_join(
    rel5,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel5), expr_reference("a", rel4))),
      expr_function("___eq_na_matches_na", list(expr_reference("b", rel5), expr_reference("b", rel4)))
    ),
    "semi"
  )
  "semi_join"
  rel7 <- rel_order(rel6, list(expr_reference("___row_number_x", rel5)))
  "semi_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_project(
    rel9,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel11 <- rel_filter(
    rel10,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel12 <- rel_order(rel11, list(expr_reference("___row_number")))
  "distinct"
  rel13 <- rel_project(
    rel12,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel13
  out <- rel_to_altrep(rel13)
  expect_identical(
    out,
    data.frame(a = 2:4, b = rep(2, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# intersect order-enforcing ------------------------------------------------------------

test_that("relational intersect() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "intersect"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "intersect"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "intersect"
  rel3 <- rel_set_intersect(rel1, rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a"), expr_reference("b")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = 2:4, b = rep(2, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# left_join order-preserving -----------------------------------------------------------

test_that("relational left_join(join_by(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "left_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "left_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "left_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "left_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "left_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "left_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "left_join"
  rel7 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a_x")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "left_join"
  rel8 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a_y")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "left_join"
  rel9 <- rel_join(
    rel7,
    rel8,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
    ),
    "left"
  )
  "left_join"
  rel10 <- rel_order(
    rel9,
    list(expr_reference("___row_number_x", rel7), expr_reference("___row_number_y", rel8))
  )
  "left_join"
  rel11 <- rel_project(
    rel10,
    list(
      {
        tmp_expr <- expr_function("___coalesce", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 1:4, b.x = rep(2, 4L), b.y = c(NA, 2, 2, 2))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# left_join order-enforcing ------------------------------------------------------------

test_that("relational left_join(join_by(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "left_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "left_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "left_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "left_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "left_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "left_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "left_join"
  rel7 <- rel_join(
    rel5,
    rel6,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
    ),
    "left"
  )
  "left_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_function("___coalesce", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- rel_order(
    rel8,
    list(expr_reference("a"), expr_reference("b.x"), expr_reference("b.y"))
  )
  rel9
  out <- rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 1:4, b.x = rep(2, 4L), b.y = c(NA, 2, 2, 2))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# mutate order-preserving --------------------------------------------------------------

test_that("relational mutate() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  rel1
  out <- rel_to_altrep(rel1)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1, .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a + 1")
        expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = a + 1) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = seq(2, 7, by = 1)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(`if` = a + 1) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "if")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `if` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("sum", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = rep(21, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("sum", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("sum(a)")
        expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = c(1, 5, 5, 15, 15, 15),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("mean", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = rep(3.5, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("mean", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("mean(a)")
        expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = c(1, 2.5, 2.5, 5, 5, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("stddev", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = rep(0x1.deeea11683f49p+0, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("stddev", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("sd(a)")
        expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = c(NA, 0.7071067811865476, 0.7071067811865476, 1, 1, 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, 1, 2, 3, 4, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lag(a)")
        expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, NA, 2, NA, 4, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(2, 3, 4, 5, 6, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lead(a)")
        expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(NA, 3, NA, 5, 6, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = c(NA, NA, 1, 2, 3, 4),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lag(a, 2)")
        expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = rep(c(NA, 4), c(5L, 1L)),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(3, 4, 5, 6, NA, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lead(a, 2)")
        expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(NA, NA, NA, 6, NA, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = c(NA, NA, NA, NA, 1, 2),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lag(a, 4)")
        expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = rep(NA_real_, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = c(5, 6, NA, NA, NA, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lead(a, 4)")
        expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = rep(NA_real_, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(0, experimental = experimental)
          } else {
            expr_constant(0)
          }
        )
        expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = seq(0, 5, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(0, experimental = experimental)
          } else {
            expr_constant(0)
          }
        )
        expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lag(a, default = 0)")
        expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = c(0, 0, 2, 0, 4, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1000, experimental = experimental)
          } else {
            expr_constant(1000)
          }
        )
        expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(2, 3, 4, 5, 6, 1000),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1000, experimental = experimental)
          } else {
            expr_constant(1000)
          }
        )
        expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("lead(a, default = 1000)")
        expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(1000, 3, 1000, 5, 6, 1000),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("min", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = rep(1, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("min", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("min(a)")
        expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("max", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = rep(6, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("max", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("max(a)")
        expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("first_value", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = rep(1, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("first_value", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("first(a)")
        expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("last_value", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = rep(6, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("last_value", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("last(a)")
        expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function(
            "nth_value",
            list(
              expr_reference("a"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          ),
          list(),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = rep(2, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function(
            "nth_value",
            list(
              expr_reference("a"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          ),
          list(expr_reference("g")),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("nth(a, 2)")
        expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = c(NA, 3, 3, 5, 5, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a / b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___divide", list(expr_reference("a"), expr_reference("b")))
        expr_set_alias(tmp_expr, "a/b")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a/b` = seq(0.5, 3, by = 0.5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(0, experimental = experimental)
        } else {
          expr_constant(0)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            },
            expr_reference("d")
          )
        )
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(0, experimental = experimental)
            } else {
              expr_constant(0)
            },
            expr_reference("d")
          )
        )
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "___divide",
          list(
            expr_function(
              "-",
              list(
                if ("experimental" %in% names(formals(expr_constant))) {
                  expr_constant(1, experimental = experimental)
                } else {
                  expr_constant(1)
                }
              )
            ),
            expr_reference("d")
          )
        )
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("f")
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = rep(-Inf, 6L),
      d = numeric(6),
      e = rep(Inf, 6L),
      f = rep(NaN, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d))) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  invisible(dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(0, experimental = experimental)
        } else {
          expr_constant(0)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("suppressWarnings", list(expr_function("___log", list(expr_reference("d")))))
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = numeric(6),
      d = rep(-1, 6L),
      e = rep(-Inf, 6L),
      f = rep(NaN, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d))) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  invisible(dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(0, experimental = experimental)
        } else {
          expr_constant(0)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log10", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("suppressWarnings", list(expr_function("___log10", list(expr_reference("d")))))
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = numeric(6),
      d = rep(-1, 6L),
      e = rep(-Inf, 6L),
      f = rep(NaN, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log(c)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(10, experimental = experimental)
        } else {
          expr_constant(10)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(10, 6L),
      d = rep(2.302585092994046, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log10(c)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(10, experimental = experimental)
        } else {
          expr_constant(10)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log10", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(10, 6L),
      d = rep(1, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = grepl('.', c)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      'CREATE MACRO "grepl"(pattern, x) AS (CASE WHEN x IS NULL THEN FALSE ELSE regexp_matches(x, pattern) END)'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_character_, experimental = experimental)
        } else {
          expr_constant(NA_character_)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "grepl",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(".", experimental = experimental)
            } else {
              expr_constant(".")
            },
            expr_reference("c")
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(NA_character_, 6L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NA_real_) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL OR isnan(x))'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("is.na", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NULL) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(FALSE, experimental = experimental)
        } else {
          expr_constant(FALSE)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% integer()) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(FALSE, experimental = experimental)
        } else {
          expr_constant(FALSE)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_, e = is.na(d)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL OR isnan(x))'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_real_, experimental = experimental)
        } else {
          expr_constant(NA_real_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("is.na", list(expr_reference("d")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_real_, 6L),
      e = rep(TRUE, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NaN, e = is.na(d)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL OR isnan(x))'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NaN, experimental = experimental)
        } else {
          expr_constant(NaN)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("is.na", list(expr_reference("d")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NaN, 6L),
      e = rep(TRUE, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number()) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "r_base::as.integer",
          list(
            expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L), d = 1:6)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number(), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("___row_number")
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "r_base::as.integer",
          list(
            expr_window(expr_function("row_number", list()), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = c(1L, 1L, 2L, 1L, 2L, 3L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = .data$b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(2, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "___null"() AS CAST(NULL AS BOOLEAN)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___null", list())
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_integer_) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_integer_, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_real_, experimental = experimental)
        } else {
          expr_constant(NA_real_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_real_, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_character_) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_character_, experimental = experimental)
        } else {
          expr_constant(NA_character_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_character_, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = if_else(a > 1, \"ok\", NA)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      'CREATE MACRO "if_else"(test, yes, no) AS (CASE WHEN test THEN yes ELSE no END)'
    )
  )
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO ">"(x, y) AS "r_base::>"(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "if_else",
          list(
            expr_function(
              ">",
              list(
                expr_reference("a"),
                if ("experimental" %in% names(formals(expr_constant))) {
                  expr_constant(1, experimental = experimental)
                } else {
                  expr_constant(1)
                }
              )
            ),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant("ok", experimental = experimental)
            } else {
              expr_constant("ok")
            },
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(NA, experimental = experimental)
            } else {
              expr_constant(NA)
            }
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(c(NA, "ok"), c(1L, 5L))
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

# mutate order-enforcing ---------------------------------------------------------------

test_that("relational mutate() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- rel_order(
    rel1,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("a + 1"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1, .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("a + 1"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = a + 1) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = seq(2, 7, by = 1)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(`if` = a + 1) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "if")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("if"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `if` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("sum", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("sum(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = rep(21, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("sum", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("sum(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = c(1, 5, 5, 15, 15, 15),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("mean", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("mean(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = rep(3.5, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("mean", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("mean(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = c(1, 2.5, 2.5, 5, 5, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("stddev", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("sd(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = rep(0x1.deeea11683f49p+0, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("stddev", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("sd(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = c(NA, 0.7071067811865476, 0.7071067811865476, 1, 1, 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, 1, 2, 3, 4, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, NA, 2, NA, 4, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(2, 3, 4, 5, 6, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(NA, 3, NA, 5, 6, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a, 2)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = c(NA, NA, 1, 2, 3, 4),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a, 2)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = rep(c(NA, 4), c(5L, 1L)),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a, 2)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(3, 4, 5, 6, NA, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(2, experimental = experimental)
          } else {
            expr_constant(2)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a, 2)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(NA, NA, NA, 6, NA, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a, 4)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = c(NA, NA, NA, NA, 1, 2),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a, 4)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = rep(NA_real_, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a, 4)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = c(5, 6, NA, NA, NA, NA),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(4, experimental = experimental)
          } else {
            expr_constant(4)
          },
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a, 4)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = rep(NA_real_, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(0, experimental = experimental)
          } else {
            expr_constant(0)
          }
        )
        expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a, default = 0)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = seq(0, 5, by = 1),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lag", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(0, experimental = experimental)
          } else {
            expr_constant(0)
          }
        )
        expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lag(a, default = 0)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = c(0, 0, 2, 0, 4, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1000, experimental = experimental)
          } else {
            expr_constant(1000)
          }
        )
        expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a, default = 1000)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(2, 3, 4, 5, 6, 1000),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function("lead", list(x = expr_reference("a"))),
          list(expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1000, experimental = experimental)
          } else {
            expr_constant(1000)
          }
        )
        expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("lead(a, default = 1000)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(1000, 3, 1000, 5, 6, 1000),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("min", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("min(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = rep(1, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("min", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("min(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("max", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("max(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = rep(6, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("max", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("max(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("first_value", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("first(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = rep(1, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("first_value", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("first(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("last_value", list(expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("last(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = rep(6, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("last_value", list(expr_reference("a"))), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("last(a)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function(
            "nth_value",
            list(
              expr_reference("a"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          ),
          list(),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("nth(a, 2)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = rep(2, 6L),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(
          expr_function(
            "nth_value",
            list(
              expr_reference("a"),
              if ("experimental" %in% names(formals(expr_constant))) {
                expr_constant(2, experimental = experimental)
              } else {
                expr_constant(2)
              }
            )
          ),
          list(expr_reference("g")),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("nth(a, 2)"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = c(NA, 3, 3, 5, 5, 5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a / b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___divide", list(expr_reference("a"), expr_reference("b")))
        expr_set_alias(tmp_expr, "a/b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("a/b"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a/b` = seq(0.5, 3, by = 0.5),
      check.names = FALSE
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(0, experimental = experimental)
        } else {
          expr_constant(0)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            },
            expr_reference("d")
          )
        )
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(0, experimental = experimental)
            } else {
              expr_constant(0)
            },
            expr_reference("d")
          )
        )
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "___divide",
          list(
            expr_function(
              "-",
              list(
                if ("experimental" %in% names(formals(expr_constant))) {
                  expr_constant(1, experimental = experimental)
                } else {
                  expr_constant(1)
                }
              )
            ),
            expr_reference("d")
          )
        )
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("f")
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "arrange"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"), expr_reference("e"), expr_reference("f"))
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = rep(-Inf, 6L),
      d = numeric(6),
      e = rep(Inf, 6L),
      f = rep(NaN, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d))) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  invisible(dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(0, experimental = experimental)
        } else {
          expr_constant(0)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("suppressWarnings", list(expr_function("___log", list(expr_reference("d")))))
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "arrange"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"), expr_reference("d"), expr_reference("e"), expr_reference("f"))
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = numeric(6),
      d = rep(-1, 6L),
      e = rep(-Inf, 6L),
      f = rep(NaN, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d))) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  invisible(dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(0, experimental = experimental)
        } else {
          expr_constant(0)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- rel_project(
    rel3,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log10", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("e")
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("suppressWarnings", list(expr_function("___log10", list(expr_reference("d")))))
        expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "arrange"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"), expr_reference("d"), expr_reference("e"), expr_reference("f"))
  )
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = numeric(6),
      d = rep(-1, 6L),
      e = rep(-Inf, 6L),
      f = rep(NaN, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log(c)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(10, experimental = experimental)
        } else {
          expr_constant(10)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"), expr_reference("d"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(10, 6L),
      d = rep(2.302585092994046, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log10(c)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(10, experimental = experimental)
        } else {
          expr_constant(10)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___log10", list(expr_reference("c")))
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"), expr_reference("d"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(10, 6L),
      d = rep(1, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = grepl('.', c)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      'CREATE MACRO "grepl"(pattern, x) AS (CASE WHEN x IS NULL THEN FALSE ELSE regexp_matches(x, pattern) END)'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_character_, experimental = experimental)
        } else {
          expr_constant(NA_character_)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "grepl",
          list(
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(".", experimental = experimental)
            } else {
              expr_constant(".")
            },
            expr_reference("c")
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"), expr_reference("d"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(NA_character_, 6L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NA_real_) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL OR isnan(x))'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("is.na", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NULL) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(FALSE, experimental = experimental)
        } else {
          expr_constant(FALSE)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% integer()) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(FALSE, experimental = experimental)
        } else {
          expr_constant(FALSE)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = logical(6)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_, e = is.na(d)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL OR isnan(x))'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_real_, experimental = experimental)
        } else {
          expr_constant(NA_real_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("is.na", list(expr_reference("d")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"), expr_reference("e"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_real_, 6L),
      e = rep(TRUE, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NaN, e = is.na(d)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL OR isnan(x))'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NaN, experimental = experimental)
        } else {
          expr_constant(NaN)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("d")
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("is.na", list(expr_reference("d")))
        expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- rel_order(
    rel3,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"), expr_reference("e"))
  )
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NaN, 6L),
      e = rep(TRUE, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number()) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "r_base::as.integer",
          list(
            expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L), d = 1:6)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number(), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "r_base::as.integer",
          list(
            expr_window(expr_function("row_number", list()), list(expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = c(1L, 1L, 2L, 1L, 2L, 3L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = .data$b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("c"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = rep(2, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "___null"() AS CAST(NULL AS BOOLEAN)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("___null", list())
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_integer_) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_integer_, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_real_, experimental = experimental)
        } else {
          expr_constant(NA_real_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_real_, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_character_) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_character_, experimental = experimental)
        } else {
          expr_constant(NA_character_)
        }
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(NA_character_, 6L)
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = if_else(a > 1, \"ok\", NA)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(
      con,
      'CREATE MACRO "if_else"(test, yes, no) AS (CASE WHEN test THEN yes ELSE no END)'
    )
  )
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO ">"(x, y) AS "r_base::>"(x, y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "if_else",
          list(
            expr_function(
              ">",
              list(
                expr_reference("a"),
                if ("experimental" %in% names(formals(expr_constant))) {
                  expr_constant(1, experimental = experimental)
                } else {
                  expr_constant(1)
                }
              )
            ),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant("ok", experimental = experimental)
            } else {
              expr_constant("ok")
            },
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(NA, experimental = experimental)
            } else {
              expr_constant(NA)
            }
          )
        )
        expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"), expr_reference("d"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = rep(2, 6L),
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(c(NA, "ok"), c(1L, 5L))
    )
  )
  dbDisconnect(con, shutdown = TRUE)
})

# relocate order-preserving ------------------------------------------------------------

test_that("relational relocate(g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(g, .before = b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), g = c(1L, 2L, 2L, 3L, 3L, 3L), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a:b, .after = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# relocate order-enforcing -------------------------------------------------------------

test_that("relational relocate(g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("g"), expr_reference("a"), expr_reference("b"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(g, .before = b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("g"), expr_reference("b"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), g = c(1L, 2L, 2L, 3L, 3L, 3L), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a:b, .after = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("g"), expr_reference("a"), expr_reference("b"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# rename order-preserving --------------------------------------------------------------

test_that("relational rename() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational rename(c = a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(c = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# rename order-enforcing ---------------------------------------------------------------

test_that("relational rename() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational rename(c = a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("c"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# right_join order-preserving ----------------------------------------------------------

test_that("relational right_join(join_by(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "right_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "right_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "right_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "right_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "right_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "right_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "right_join"
  rel7 <- rel_project(
    rel5,
    list(
      {
        tmp_expr <- expr_reference("a_x")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "right_join"
  rel8 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a_y")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "right_join"
  rel9 <- rel_join(
    rel7,
    rel8,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel7), expr_reference("a_y", rel8)))
    ),
    "right"
  )
  "right_join"
  rel10 <- rel_order(
    rel9,
    list(expr_reference("___row_number_x", rel7), expr_reference("___row_number_y", rel8))
  )
  "right_join"
  rel11 <- rel_project(
    rel10,
    list(
      {
        tmp_expr <- expr_reference("a_y", rel8)
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 2:5, b.x = c(2, 2, 2, NA), b.y = rep(2, 4L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# right_join order-enforcing -----------------------------------------------------------

test_that("relational right_join(join_by(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "right_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "right_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "right_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "right_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "right_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "right_join"
  rel6 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "right_join"
  rel7 <- rel_join(
    rel5,
    rel6,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a_x", rel5), expr_reference("a_y", rel6)))
    ),
    "right"
  )
  "right_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a_y", rel6)
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_x")
        expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b_y")
        expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- rel_order(
    rel8,
    list(expr_reference("a"), expr_reference("b.x"), expr_reference("b.y"))
  )
  rel9
  out <- rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 2:5, b.x = c(2, 2, 2, NA), b.y = rep(2, 4L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# select order-preserving --------------------------------------------------------------

test_that("relational select(a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(-g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(everything()) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# select order-enforcing ---------------------------------------------------------------

test_that("relational select(a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("a")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(-g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("a"), expr_reference("b")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(everything()) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(
    rel2,
    list(expr_reference("a"), expr_reference("b"), expr_reference("g"))
  )
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# semi_join order-preserving -----------------------------------------------------------

test_that("relational semi_join(join_by(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "semi_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "semi_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "semi_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "semi_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "semi_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "semi_join"
  rel6 <- rel_join(
    rel5,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel5), expr_reference("a", rel4)))
    ),
    "semi"
  )
  "semi_join"
  rel7 <- rel_order(rel6, list(expr_reference("___row_number_x", rel5)))
  "semi_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel8
  out <- rel_to_altrep(rel8)
  expect_identical(
    out,
    data.frame(a = 2:4, b = rep(2, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# semi_join order-enforcing ------------------------------------------------------------

test_that("relational semi_join(join_by(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "semi_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "semi_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "semi_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "semi_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "semi_join"
  rel5 <- rel_join(
    rel2,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel2), expr_reference("a", rel4)))
    ),
    "semi"
  )
  "arrange"
  rel6 <- rel_order(rel5, list(expr_reference("a"), expr_reference("b")))
  rel6
  out <- rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = 2:4, b = rep(2, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# setdiff order-preserving -------------------------------------------------------------

test_that("relational setdiff() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "anti_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "anti_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "anti_join"
  rel6 <- rel_join(
    rel5,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel5), expr_reference("a", rel4))),
      expr_function("___eq_na_matches_na", list(expr_reference("b", rel5), expr_reference("b", rel4)))
    ),
    "anti"
  )
  "anti_join"
  rel7 <- rel_order(rel6, list(expr_reference("___row_number_x", rel5)))
  "anti_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_project(
    rel9,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel11 <- rel_filter(
    rel10,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel12 <- rel_order(rel11, list(expr_reference("___row_number")))
  "distinct"
  rel13 <- rel_project(
    rel12,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel13
  out <- rel_to_altrep(rel13)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# setdiff order-enforcing --------------------------------------------------------------

test_that("relational setdiff() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "setdiff"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "setdiff"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "setdiff"
  rel3 <- rel_set_diff(rel1, rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a"), expr_reference("b")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# summarise order-preserving -----------------------------------------------------------

test_that("relational summarise(c = mean(a)) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function("mean", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = 3.5)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = b) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_aggregate(
    rel2,
    groups = list(expr_reference("b")),
    aggregates = list(
      {
        tmp_expr <- expr_function("min", list(expr_reference("___row_number")))
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("mean", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "summarise"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(b = 2, c = 3.5)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_aggregate(
    rel2,
    groups = list(expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- expr_function("min", list(expr_reference("___row_number")))
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_function("mean", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "summarise"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(g = 1:3, c = c(1, 2.5, 5))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(1, experimental = experimental)
        } else {
          expr_constant(1)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = 1)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1, .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_aggregate(
    rel2,
    groups = list(expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- expr_function("min", list(expr_reference("___row_number")))
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(1, experimental = experimental)
        } else {
          expr_constant(1)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "summarise"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("c")
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(g = 1:3, c = rep(1, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L, .by = g) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_aggregate(
    rel2,
    groups = list(expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- expr_function("min", list(expr_reference("___row_number")))
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_function("n", list()),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1L, experimental = experimental)
            } else {
              expr_constant(1L)
            }
          )
        )
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- rel_order(rel3, list(expr_reference("___row_number")))
  "summarise"
  rel5 <- rel_project(
    rel4,
    list(
      {
        tmp_expr <- expr_reference("g")
        expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("n")
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 2:4)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_function("n", list()),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1L, experimental = experimental)
            } else {
              expr_constant(1L)
            }
          )
        )
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(n = 7L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# summarise order-enforcing ------------------------------------------------------------

test_that("relational summarise(c = mean(a)) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function("mean", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("c")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(c = 3.5)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = b) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(expr_reference("b")),
    aggregates = list(
      {
        tmp_expr <- expr_function("mean", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("b"), expr_reference("c")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(b = 2, c = 3.5)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- expr_function("mean", list(expr_reference("a")))
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("g"), expr_reference("c")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, c = c(1, 2.5, 5))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(1, experimental = experimental)
        } else {
          expr_constant(1)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("c")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(c = 1)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1, .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(1, experimental = experimental)
        } else {
          expr_constant(1)
        }
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("g"), expr_reference("c")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, c = rep(1, 3L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L, .by = g) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_function("n", list()),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1L, experimental = experimental)
            } else {
              expr_constant(1L)
            }
          )
        )
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("g"), expr_reference("n")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 2:4)
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_function("n", list()),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1L, experimental = experimental)
            } else {
              expr_constant(1L)
            }
          )
        )
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("n")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(n = 7L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# symdiff order-preserving -------------------------------------------------------------

test_that("relational symdiff() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(
    dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "anti_join"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "anti_join"
  rel3 <- rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "anti_join"
  rel6 <- rel_join(
    rel5,
    rel4,
    list(
      expr_function("___eq_na_matches_na", list(expr_reference("a", rel5), expr_reference("a", rel4))),
      expr_function("___eq_na_matches_na", list(expr_reference("b", rel5), expr_reference("b", rel4)))
    ),
    "anti"
  )
  "anti_join"
  rel7 <- rel_order(rel6, list(expr_reference("___row_number_x", rel5)))
  "anti_join"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  df3 <- data.frame(a = 1L, b = 2)

  "union_all"
  rel9 <- rel_from_df(con, df3, experimental = experimental)
  df4 <- data.frame(a = 5L, b = 2)

  "union_all"
  rel10 <- rel_from_df(con, df4, experimental = experimental)
  "union_all"
  rel11 <- rel_project(
    rel9,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel12 <- rel_project(
    rel10,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel13 <- rel_union_all(rel11, rel12)
  "union_all"
  rel14 <- rel_order(
    rel13,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel15 <- rel_project(
    rel14,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel16 <- rel_project(
    rel15,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel17 <- rel_project(
    rel16,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel18 <- rel_filter(
    rel17,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel19 <- rel_order(rel18, list(expr_reference("___row_number")))
  "distinct"
  rel20 <- rel_project(
    rel19,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel20
  out <- rel_to_altrep(rel20)
  expect_identical(
    out,
    data.frame(a = c(1L, 5L), b = c(2, 2))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# symdiff order-enforcing --------------------------------------------------------------

test_that("relational symdiff() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "symdiff"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "symdiff"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "symdiff"
  rel3 <- rel_set_symdiff(rel1, rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a"), expr_reference("b")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = c(1L, 5L), b = c(2, 2))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# tally order-preserving ---------------------------------------------------------------

test_that("relational tally() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# tally order-enforcing ----------------------------------------------------------------

test_that("relational tally() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- expr_function("n", list())
        expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- rel_distinct(rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("n")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  dbDisconnect(con, shutdown = TRUE)
})

# transmute order-preserving -----------------------------------------------------------

test_that("relational transmute(c = a + 1) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- rel_project(
    rel1,
    list(
      c = {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(c = seq(2, 7, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational transmute(row = a) order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- rel_project(
    rel1,
    list(
      row = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "row")
        tmp_expr
      }
    )
  )
  rel2
  out <- rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(row = seq(1, 6, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# transmute order-enforcing ------------------------------------------------------------

test_that("relational transmute(c = a + 1) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- rel_project(
    rel1,
    list(
      c = {
        tmp_expr <- expr_function(
          "+",
          list(
            expr_reference("a"),
            if ("experimental" %in% names(formals(expr_constant))) {
              expr_constant(1, experimental = experimental)
            } else {
              expr_constant(1)
            }
          )
        )
        expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("c")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = seq(2, 7, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

test_that("relational transmute(row = a) order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = rep(2, 6L), g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- rel_project(
    rel1,
    list(
      row = {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "row")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- rel_order(rel2, list(expr_reference("row")))
  rel3
  out <- rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(row = seq(1, 6, by = 1))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# union order-preserving ---------------------------------------------------------------

test_that("relational union() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  invisible(rapi_load_rfuns(drv@database_ref))
  invisible(dbExecute(con, 'CREATE MACRO "=="(x, y) AS "r_base::=="(x, y)'))
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- rel_project(
    rel7,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- rel_project(
    rel8,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      expr_reference("___row_number"),
      {
        tmp_expr <- expr_window(
          expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- expr_reference("a")
              expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- expr_reference("b")
              expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- rel_filter(
    rel9,
    list(
      expr_function(
        "==",
        list(
          expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(expr_constant))) {
            expr_constant(1L, experimental = experimental)
          } else {
            expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- rel_order(rel10, list(expr_reference("___row_number")))
  "distinct"
  rel12 <- rel_project(
    rel11,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel12
  out <- rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(a = 1:5, b = rep(2, 5L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# union order-enforcing ----------------------------------------------------------------

test_that("relational union() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- rel_distinct(rel3)
  "arrange"
  rel5 <- rel_order(rel4, list(expr_reference("a"), expr_reference("b")))
  rel5
  out <- rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = 1:5, b = rep(2, 5L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# union_all order-preserving -----------------------------------------------------------

test_that("relational union_all() order-preserving", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_project(
    rel1,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- rel_project(
    rel2,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(expr_constant))) {
          expr_constant(NA_integer_, experimental = experimental)
        } else {
          expr_constant(NA_integer_)
        }
        expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- expr_window(expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- rel_order(
    rel5,
    list(expr_reference("___row_number_x"), expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- rel_project(
    rel6,
    list(
      {
        tmp_expr <- expr_reference("a")
        expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- expr_reference("b")
        expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel7
  out <- rel_to_altrep(rel7)
  expect_identical(
    out,
    data.frame(a = c(1L, 2L, 3L, 4L, 2L, 3L, 4L, 5L), b = rep(2, 8L))
  )
  dbDisconnect(con, shutdown = TRUE)
})

# union_all order-enforcing ------------------------------------------------------------

test_that("relational union_all() order-enforcing", {
  # Autogenerated
  drv <- duckdb()
  con <- dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = rep(2, 4L))

  "union_all"
  rel1 <- rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = rep(2, 4L))

  "union_all"
  rel2 <- rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- rel_union_all(rel1, rel2)
  "arrange"
  rel4 <- rel_order(rel3, list(expr_reference("a"), expr_reference("b")))
  rel4
  out <- rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = c(1L, 2L, 2L, 3L, 3L, 4L, 4L, 5L), b = rep(2, 8L))
  )
  dbDisconnect(con, shutdown = TRUE)
})
