% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect-rd.R, R/collect.R
\name{collect.duckplyr_df}
\alias{collect.duckplyr_df}
\title{Force conversion to a data frame}
\usage{
\method{collect}{duckplyr_df}(x, ...)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for more
details.}

\item{...}{Arguments passed on to methods}
}
\description{
This is a method for the \code{\link[dplyr:compute]{dplyr::collect()}} generic.
\code{collect()} converts the input to a tibble, materializing any lazy operations.
}
\examples{
library(duckplyr)
df <- duckdb_tibble(x = c(1, 2), .lazy = TRUE)
df
try(print(df$x))
df <- collect(df)
df
}
\seealso{
\code{\link[dplyr:compute]{dplyr::collect()}}
}
