% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_routing_table.r
\name{build_routing_table}
\alias{build_routing_table}
\title{Generate a network routing table}
\usage{
build_routing_table(dem, chans = NULL, outlet = NULL, breaks = 5,
  len.fun = flow.lens)
}
\arguments{
\item{dem}{Elevation raster using a projected coordinate system (e.g UTM) and a regular grid spacing. Areas outside the catchment should be set to NA}

\item{chans}{Optional raster of the same dimensions and resolution as the DEM. Non-zero cells in this raster are considered to contain a river channel. If not supplied then flowpaths from the entire catchment area are considered.}

\item{outlet}{Index of cell or cells identified with the catchment outlet}

\item{breaks}{Number of distance intervals}

\item{len.fun}{For large rasters the flow.len function can be very slow and many paths fail to reach a single outlet cell. This applies a simple straight line distance to the outlet to obtain a rough approximation.}
}
\value{
A two-column data.frame. Its first column is the average flow distance to the outlet, in m, the second the proportions of the catchment channel network within each distance category.
}
\description{
Generates a network width table for a catchment. When passed to the run.dtm routine this will be used to route channel flows to the outlet during a Dynamic TOPMODEL run.
}
\details{
Dynamic TOPMODEL routes channel flow to the outlet by a network-width approach (see Beven, 2012, pp. 97-97). A time-delay histogram is produced using the table. When any flow is distributed to the channel "unit" it is immediately redistributed across future time steps according to the proportions found in the histogram. These flows are then added to future outputs from the model.
}
\examples{
\dontrun{
# Create a routing table for the Brompton test case and show histogram

data(brompton)

tab <- build_routing_table(brompton$dem,
  chans=brompton$reaches,
  breaks=5)
barplot(tab[,2]*100, xlab="Mean flow distance to outlet (m)",
ylab="Network Width \%", names.arg=tab[,1])
}
}
\references{
Beven, K. J. (2012). Rainfall-runoff modelling : the primer. Chichester, UK, Wiley-Blackwell.
}
\author{
Peter Metcalfe
}
