% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_igraph_network.R
\name{simplify_igraph_network}
\alias{simplify_igraph_network}
\title{Simplify an igraph network such that consecutive linear edges are removed}
\usage{
simplify_igraph_network(
  gr,
  allow_duplicated_edges = TRUE,
  allow_self_loops = TRUE,
  force_keep = NULL,
  edge_points = NULL
)
}
\arguments{
\item{gr}{An igraph object, see \code{\link[igraph:graph]{igraph::graph()}}}

\item{allow_duplicated_edges}{Whether or not to allow duplicated edges between nodes.}

\item{allow_self_loops}{Whether or not to allow self loops.}

\item{force_keep}{Nodes that will not be removed under any condition}

\item{edge_points}{Points that are on edges}
}
\description{
\itemize{
\item Nodes with degree 2 (or indegree 1 and outdegree 1) are removed: A -> B -> C becomes A -> C
\item Cycles contain at least 3 nodes, ie. A -> B -> A becomes A -> B -> C -> A
\item Loops are converted to a cycle, unless \code{allow_self_loops = TRUE}
\item Duplicated edges are removed, unless \code{allow_duplcated_edges = FALSE}
}
}
\examples{
net <- data.frame(
  from = 1:2,
  to = 2:3,
  length = 1,
  directed = TRUE,
  stringsAsFactors = F
)
gr <- igraph::graph_from_data_frame(net)
simplify_igraph_network(gr)

net <- data.frame(
  from = c(1, 2, 3, 1),
   to = c(2, 3, 1, 4),
    length = 1,
    directed = TRUE,
    stringsAsFactors = F
)
gr <- igraph::graph_from_data_frame(net)
simplify_igraph_network(gr)

net <- data.frame(
  from = c(1, 2, 3, 4),
   to = c(2, 3, 1, 5),
    length = 1,
    directed = TRUE,
    stringsAsFactors = F
)
gr <- igraph::graph_from_data_frame(net)
simplify_igraph_network(gr)
}
