% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindf-joinf.R
\name{ljoinf}
\alias{ljoinf}
\title{Left Join with Factors}
\usage{
ljoinf(
  data.left,
  data.right,
  by,
  sort.levels = TRUE,
  restrict.levels = FALSE,
  na_level = "(Missing)"
)
}
\arguments{
\item{data.left}{Left data. All of this data will be preservered in the join (may still result in duplication).}

\item{data.right}{Right data. Only rows that matche the join will be included (may also result in duplication).}

\item{by}{Columns to join on.}

\item{sort.levels}{Sort the factor levels after combining them.}

\item{restrict.levels}{Often the joined data won't use all the levels in both datasets. Set to TRUE to remove factor levels that aren't in the joined data.}

\item{na_level}{some functions don't like factors to have NAs so we replace NAs with this value for factors only. Set NULL to skip.}
}
\value{
Joined data, with any factors modified to contain all levels in the joined data.
}
\description{
Matches factor levels before left join via merge.
Author: Bryce Chamberlain.
}
\examples{

df1 = data.frame(
  factor1 = c( 'a', 'b', 'c' ),
  factor2 = c( 'high', 'medium', 'low' ),
  factor.join = c( '0349038u093843', '304359867893753', '3409783509735' ),
  numeric = c( 1, 2, 3 ),
  logical = c( TRUE, TRUE, TRUE )
)

df2 = data.frame(
  factor1 = c( 'd', 'e', 'f' ),
  factor2 = c( 'low', 'medium', 'high' ),
  factor.join = c( '32532532536', '304359867893753', '32534745876' ),
  numeric = c( 4, 5, 6 ),
  logical = c( FALSE, FALSE, FALSE )
)

ljoinf( df1, df2, by = 'factor.join' )

}
