% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cloglog}
\alias{plot_cloglog}
\title{Cumulative Log Log Plot}
\usage{
plot_cloglog(
  fit,
  median_line = FALSE,
  legend_position = "top",
  plot_theme = theme_easysurv()
)
}
\arguments{
\item{fit}{A \link[survival:survfit]{survival::survfit} object representing the
survival data.}

\item{median_line}{Logical value indicating whether to include a line
representing the median survival time. Default is \code{FALSE}.}

\item{legend_position}{Position of the legend in the plot. Default is
"top".}

\item{plot_theme}{ggplot2 theme for the plot. Default is
\code{theme_easysurv()}.}
}
\value{
A ggplot object representing the cumulative log log plot.
}
\description{
Generates a Cumulative Log Log survival curve plot using
\code{\link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit()}} with customizable options.
}
\examples{
library(ggsurvfit)
fit <- survfit2(Surv(time, status) ~ surg, data = df_colon)
plot_cloglog(fit)
}
