% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemValuesMinMax.R
\name{itemValuesRange}
\alias{itemValuesRange}
\alias{itemValuesMin}
\alias{itemValuesMax}
\alias{itemValuesDeviation}
\title{Create single value constraints with minimum and maximum.}
\usage{
itemValuesRange(
  nForms,
  itemValues,
  range,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)

itemValuesMin(
  nForms,
  itemValues,
  min,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)

itemValuesMax(
  nForms,
  itemValues,
  max,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)

itemValuesDeviation(
  nForms,
  itemValues,
  targetValue,
  allowedDeviation,
  relative = FALSE,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{range}{a vector with two values, the the minimal and the maximum sum of
the \code{itemValues} per test form, respectively}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}

\item{min}{the minimal sum of the \code{itemValues} per test form}

\item{max}{the minimal sum of the \code{itemValues} per test form}

\item{targetValue}{the target test form value.}

\item{allowedDeviation}{the maximum allowed deviation from the \code{targetValue}}

\item{relative}{a logical expressing whether or not the \code{allowedDeviation}
should be interpreted as a proportion of the \code{targetValue}}
}
\value{
An object of class \code{"constraint"}.
}
\description{
\code{itemValuesRange}, \code{itemValuesMin}, and \code{itemValuesMax}
create constraints related to an item parameter/value. That is, the created
constraints assure that the sum of the \code{itemValues} is smaller than or equal
to \code{max}, greater than or equal to \code{min}, or both \code{range}.
}
\details{
\code{itemValuesDeviation} also constrains the minimal and the maximal value
of the sum of the \code{itemValues}, but based on a chosen
and a maximal allowed deviation (i.e., \code{allowedDeviation}) from that \code{targetValue}.
}
\section{Functions}{
\itemize{
\item \code{itemValuesMin}: constrain minimum value

\item \code{itemValuesMax}: constrain maximum value

\item \code{itemValuesDeviation}: constrain the distance form the \code{targetValue}
}}

\examples{
## constraints to make sure that the sum of the item values (1:10) is between
## 4 and 6
itemValuesRange (2, 1:10, range(min = 4, max = 6))

## or alternatively
itemValuesDeviation (2, 1:10, targetValue = 5, allowedDeviation = 1)

}
