% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_spss.R
\name{write_spss}
\alias{write_spss}
\title{Write a \code{GADSdat} object to \code{sav}}
\usage{
write_spss(GADSdat, filePath)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{filePath}{Path of \code{sav} file to write.}
}
\value{
Writes \code{sav} file to disc, returns \code{NULL}.
}
\description{
Write a \code{GADSdat} object, which contains meta information as value and variable labels to an SPSS file (\code{sav}).
See 'details' for some important limitations.
}
\details{
The provided functionality relies on \code{havens} \code{\link[haven:read_spss]{write_sav}} function.
Currently known limitations are:
(a) Missing codes for all character variables are dropped, (b) value labels for long character variables (> \code{A10}) are
dropped, (c) under specific conditions very long character variables (> \code{A254}) are incorrectly displayed as multiple
character variables in \code{SPSS}. Furthermore, \code{write_spss} currently does not support exporting date or time variables.
}
\examples{
tmp <- tempfile(fileext = ".sav")
write_spss(pisa, tmp)

}
