% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_RDS.R
\name{import_RDS}
\alias{import_RDS}
\title{Import \code{RDS} file}
\usage{
import_RDS(filePath, checkVarNames = TRUE)
}
\arguments{
\item{filePath}{Source file location, ending on \code{.RDS}.}

\item{checkVarNames}{Should variable names be checked for violations of \code{SQLite} and \code{R} naming rules?}
}
\value{
Returns a list with the actual data \code{dat} and a data frame with all meta information in long format \code{labels}.
}
\description{
Function to import a \code{data.frame} stored as a \code{.RDS} file while extracting value labels from factors.
}
\details{
Factors are integers with labeled variable levels. \code{import_RDS} extracts these labels and stores them in a separate meta data data.frame.
See \code{\link{import_DF}} for detailed information. This function is a wrapper around \code{\link{import_DF}}.
}
