% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateScale.R
\name{calculateScale}
\alias{calculateScale}
\title{Calculate a scale.}
\usage{
calculateScale(
  GADSdat,
  items,
  scale,
  maxNA = length(items),
  reportDescr = FALSE
)
}
\arguments{
\item{GADSdat}{A \code{data.frame} or \code{GADSdat} object.}

\item{items}{A character vector with all item variable names.}

\item{scale}{A character vector with the scale name.}

\item{maxNA}{Maximum number of allowed \code{NA} values on the items.}

\item{reportDescr}{Should descriptive statistics be reported for the calculated scale.}
}
\value{
Returns a \code{GADSdat} containing the newly computed variable.
}
\description{
Calculate a scale variable based on multiple items.
}
\details{
Descriptive statistics (including Cronbach's alpha, credit to the \code{psy} package) are calculated and printed to the console.
The new scale variable is automatically inserted right after the last item in the original \code{GADSdat}.
}
\examples{
##
items <- paste0("norms_", letters[1:6])
pisa_new <- calculateScale(pisa, items = items, scale = "norms")

}
