% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subImputations.R
\name{subImputations}
\alias{subImputations}
\title{Substitute imputed values.}
\usage{
subImputations(GADSdat, GADSdat_imp, varName, varName_imp = varName, id, imp)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{GADSdat_imp}{A \code{GADSdat} object.}

\item{varName}{A character vector of length 1 containing the variable name in \code{GADSdat}.}

\item{varName_imp}{A character vector of length 1 containing the variable name in \code{GADSdat_imp}.}

\item{id}{A character vector of length 1 containing the unique identifier column of both \code{GADSdat}.}

\item{imp}{A character vector of length 1 containing the imputation number in \code{GADSdat_imp}.}
}
\value{
The modified \code{GADSdat_imp}..
}
\description{
Substitute imputed values in a imputed \code{GADSdat_imp} object with original, not imputed values from a \code{GADSdat}.
}
\details{
There are two cases in which values are substituted: (a) there are missings in \code{varName_imp}, (b) values have been imputed
even though there is valid information in \code{varName}.
}
\examples{
# tbd

}
