% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_raster}
\alias{load_raster}
\title{Load eBird Status and Trends raster data}
\usage{
load_raster(product = c("abundance_umean", "occurrence_umean",
  "abundance_lower", "abundance_upper", "template"), path)
}
\arguments{
\item{product}{character; status and trends product to load, options are
relative abundance, occurrence, and upper and lower bounds on relative
abundance. It is also possible to return a template raster with no data.}

\item{path}{character; full path to the directory containing single species
eBird Status and Trends products.}
}
\value{
A \code{RasterStack} of data for the given product.
}
\description{
Each of the eBird Status and Trends products is packaged as a GeoTIFF file
with 52 bands, one for each week of the year. This function loads the data
for a given product and species as a \code{RasterStack} object.
}
\examples{
# download example data
sp_path <- ebirdst_download("example_data")

# load data
load_raster("abundance_umean", sp_path)
}
